% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chMDB.R, R/fileMDB.R
\name{$.chMDB}
\alias{$.chMDB}
\alias{fileMDB}
\alias{names<-.fileMDB}
\alias{rename.fileMDB}
\alias{[.fileMDB}
\alias{[[.fileMDB}
\alias{$.fileMDB}
\alias{c.fileMDB}
\title{An \link{MDB} (Modeled DataBase) based on files: fileMDB}
\usage{
\method{$}{chMDB}(x, i)

fileMDB(
  dataFiles,
  dbInfo,
  dataModel,
  readParameters = DEFAULT_READ_PARAMS,
  collectionMembers = NULL,
  n_max = 10,
  verbose = FALSE
)

\method{names}{fileMDB}(x) <- value

\method{rename}{fileMDB}(.data, ...)

\method{[}{fileMDB}(x, i)

\method{[[}{fileMDB}(x, i)

\method{$}{fileMDB}(x, i)

\method{c}{fileMDB}(...)
}
\arguments{
\item{x}{a \link{fileMDB} object}

\item{i}{the index or the name of the tables to take}

\item{dataFiles}{a named vector of path to data files with
\code{all(names(dataFiles) \%in\% names(dataModel))}}

\item{dbInfo}{a list with DB information:
\strong{"name"} (only mandatory field), "title", "description", "url",
"version", "maintainer".}

\item{dataModel}{a \link[ReDaMoR:RelDataModel]{ReDaMoR::RelDataModel} object}

\item{readParameters}{a list of parameters for reading the data file.
(e.g. \code{list(delim='\\t', quoted_na=FALSE,)})}

\item{collectionMembers}{the members of collections as provided to the
\link{collection_members<-} function (default: NULL ==> no member).}

\item{n_max}{maximum number of records to read
for checks purpose (default: 10). See also \code{\link[ReDaMoR:confront_data]{ReDaMoR::confront_data()}}.}

\item{verbose}{if TRUE display the data confrontation report
(default: FALSE)}

\item{value}{new table names}

\item{.data}{a \link{fileMDB} object}

\item{...}{\link{fileMDB} objects}
}
\value{
A fileMDB object
}
\description{
An \link{MDB} (Modeled DataBase) based on files: fileMDB

Rename tables of a \link{fileMDB} object
}
\examples{
hpof <- read_fileMDB(
   path=system.file("examples/HPO-subset", package="ReDaMoR"),
   dataModel=system.file("examples/HPO-model.json", package="ReDaMoR"),
   dbInfo=list(
      "name"="HPO",
      "title"="Data extracted from the HPO database",
      "description"=paste(
         "This is a very small subset of the HPO!",
         "Visit the reference URL for more information"
      ),
      "url"="http://human-phenotype-ontology.github.io/"
   )
)
count_records(hpof)

select(hpof, HPO_hp:HPO_diseases)
toTake <- "HPO_altId"
select(hpof, all_of(toTake))

hpoSlice <- slice(hpof, HPO_diseases=1:10)
count_records(hpoSlice)

if(requireNamespace("stringr", quietly = TRUE)){
   epilHP <- filter(
      hpof,
      HPO_diseases=stringr::str_detect(
         label, stringr::regex("epilepsy", ignore_case=TRUE)
      )
   )
   count_records(epilHP)
   label <- "Rolandic epilepsy"
   cn <- sym("label")
   reHP <- filter(
      hpof,
      HPO_diseases=!!cn==!!label
   )
}
}
\seealso{
\itemize{
\item MDB methods:
\link{db_info}, \link{data_model}, \link{data_tables}, \link{collection_members},
\link{count_records}, \link{filter_with_tables}, \link{as_fileMDB}
\item Additional general documentation is related to \link{MDB}.
\item \link{filter.fileMDB}, \link{slice.fileMDB}
}
}
