% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsmclasses.R
\name{fsm}
\alias{fsm}
\alias{kfsm}
\alias{as_flat}
\alias{as_kfsm}
\alias{as_fsm}
\title{Flat storage of symmetric matrices}
\usage{
as_flat(x, ...)

as_kfsm(x, ...)

as_fsm(x, ...)
}
\arguments{
\item{x}{For \code{as_fsm()} a list of symmetric matrices, or a 2D array of flattened matrices. For \code{as_kfsm()} a list of objects that can be passed to \code{as_fsm()} (i.e. a list of a lists of matrices, or a list of 2D arrays). For \code{as_flat()}, \code{x} can be suitable for either \code{as_fsm()} or \code{as_kfsm()}.}

\item{...}{Passed to \code{\link[=isSymmetric]{isSymmetric()}} for testing whether matrices are symmetric.}
}
\value{
An object with class \code{TFORGE_kfsm} or \code{TFORGE_fsm}.
}
\description{
The \code{TFORGE_fsm} class, short for \emph{Flat Symmetric Matrices}, is for storing a collection of symmetric matrices with each matrix stored as a row vector according to \code{\link[=vech]{vech()}}.
The \code{TFORGE_fsm} class is itself a thin wrapper of the array class.
So, for example, \code{x[1, ]} will return the vectorised-form of the first matrix in the collection, and \code{inv_vech(x[1,])} will be the first matrix in non-flat form.
The \code{TFORGE_kfsm} class is for a collection of multiple \code{TFORGE_fsm}.
The function \code{as_flat()} automatically converts data to either \code{TFORGE_kfsm} or \code{TFORGE_fsm}.
}
\details{
The matrices inside \code{x} must all have the same dimension.

The function \code{as_flat()} automatically chooses between a \code{TFORGE_kfsm} or a \code{TFORGE_fsm}:
\itemize{
\item If \code{x} is a list of symmetric matrices then it will return a \code{TFORGE_fsm}.
\item If \code{x} is a list of lists of equal-sized matrices then it returns a \code{TFORGE_kfsm}, with each element of the larger list a \code{TFORGE_fsm}.
\item If \code{x} is a list of 2D arrays, each satisfying \code{as_fsm()}, then \code{as_flat()} will return a \code{TFORGE_kfsm}.
\item In the rare case that \code{x} is a list of 2D arrays of flattened matrices, but the 2D arrays happen to be perfectly symmetric (requires size of collections to perfectly relate to the dimension of the matrix observations) then \code{as_flat()} will mistakenly treat each element of \code{x} as a symmetric matrix and return a \code{TFORGE_fsm}.
}
}
\section{Functions}{
\itemize{
\item \code{as_flat()}: Automatically convert to either a \code{TFORGE_kfsm} or a \code{TFORGE_fsm}.

\item \code{as_kfsm()}: Convert multiple collections of matrices into a \code{kfsm}. \code{x} must be a list, with each entry of \code{x} a separate collection of matrices.

\item \code{as_fsm()}: For \code{x} a list of symmetric matrices of the same size, flattens \code{x} into a 2D array where the \code{i}th row is a vectorised version \code{vech(x[[i]])} of the \code{i}th matrix of  \code{x}. If \code{x} is already flattened then \code{as_fsm()} will check that the number of columns are consistent with a flattened symmetric matrix.

}}
\examples{
x <- list(list(matrix(c(1,2,3,2,4,5,3,5,6), 3), 
               matrix(c(2,3,4,3,5,6,4,6,7), 3)),
          list(matrix(c(0.1,0.2,0.3,0.2,0.4,0.5,0.3,0.5,0.6), 3), 
               matrix(c(0.2,0.3,0.4,0.3,0.5,0.6,0.4,0.6,0.7), 3)))
as_kfsm(x)
summary(as_flat(x))
}
