% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdmReadDataset.r
\name{tdmReadDataset}
\alias{tdmReadDataset}
\title{Read data accoroding to \code{opts} settings.}
\usage{
tdmReadDataset(opts)
}
\arguments{
\item{opts}{list of options, we need here
\itemize{
  \item \code{READ.TrnFn}: [tdmReadTrain] function with argument \code{opts} for reading  
                           the training data and returning them in a data frame
  \item \code{READ.NROW}:  [-1] read only that many rows from opts$filename. -1 for 'read all rows'.
  \item \code{READ.TstFn}: [NULL] function with argument \code{opts} for reading  
                           the test data and returning them in a data frame. If NULL
                           then skip test file reading.
  \item \code{TST.COL}:    ["TST.COL"] string, create a column with the name of this string 
                           in \code{dset}, which has 0 for training and 1 for test data   
  \item \code{path}:       used by READ.TrnFn to locate file
  \item \code{dir.data}:   used by READ.TrnFn to locate file
}}
}
\value{
\code{dset},  a data frame with all data read
}
\description{
Read the data accoring to the settings \code{opts$READ.*} and \code{opts$TST.COL} 
(see Details).
}
\details{
When \code{opts$READ.TstFn==NULL}, then only \code{opts$READ.TrnFn} is used. \cr 
When \code{opts$READ.TstFn!=NULL}, the following things happen in \code{\link{tdmReadDataset}}: 
Data are read from \code{opts$filename} and from \code{opts$filetest}. Both data sets are bound 
together, with a new column \code{opts$TST.COL} having '0' for the data from opts$filename and 
having '1' for the data from opts$filetest. The branch using opts$TST.COL is invoked either with 
umode="TST" in \code{\link{unbiasedRun}} or with opts$TST.kind="col" in \code{\link{tdmModCreateCVindex}}.
}
\seealso{
\code{\link{tdmReadAndSplit}}
}
