% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultSC.R
\name{defaultSC}
\alias{defaultSC}
\title{Default settings for the spotConfig part of TDMR.}
\usage{
defaultSC()
}
\value{
a list with the following elements (the values in parantheses \code{[]} are the defaults):
     \item{alg.roi}{  ["NEEDS_TO_BE_SET"] a data frame with columns \code{lower}, 
            \code{upper}, \code{type}, \code{row.names}, each a vector with as many 
            entries as there are parameter to be tuned }
     \item{opts}{  ["NEEDS_TO_BE_SET"]  }
     \item{sCName}{  ["NEEDS_TO_BE_SET.conf"] a string ending on ".conf", 
                     the configuration name }
     \item{OCBA}{  [FALSE] see \code{\link[SPOT]{spotControl}}  }
     \item{plot}{  [FALSE] TRUE: make a line plot showing progress  }
     \item{seedSPOT}{  [1] see \code{\link[SPOT]{spotControl}}  }
     \item{funEvals}{  [50] the budget, max number of algo evaluations   }
     \item{design}{  [designLHD] function that creates initial design, 
                     see \code{\link[SPOT]{spotControl}}  }
     \item{designControl.size}{  [10] number of initial design points (former init.design.size)  }
     \item{designControl.replicates}{  [2] number of initial repeats (former init.design.repeats)  }
     \item{replicates}{  [2] number of repeats for the same model design point  }
     \item{noise}{  [TRUE] whether the object function has noise or not
                    (Note: TRUE is required if \code{replicates>1} (!)) } 
     \item{seq.merge.func}{  [mean] how to merge Y over replicates: mean or min  }
     \item{model}{  [buildKriging] function that builds the surrogate model, 
                    see \code{\link[SPOT]{spotControl}}  }
     \item{optimizer}{  [optimLHD] function that optimizes on surrrogate, 
                        see \code{\link[SPOT]{spotControl}}  }
     \item{optimizerControl.funEvals}{  [100] optimizer budget (former seq.design.size)  }
     \item{optimizerControl.retries}{  [2] optimLHD retries  (former seq.design.retries)  }
}
\description{
Sets suitable defaults for the spotConfig part of TDMR.
}
\details{
With the call \code{\link{setParams}(mySC,defaultSC())} it is possible to extend a partial list 
\code{mySC} to a list containing all \code{sC}-elements (the missing ones are taken from 
\code{defaultSC()}). If \code{mySC} has an element not present in \code{defaultSC()}, 
this element is not taken and a warning is issued. \cr
With \code{\link{setParams}(mySC,defaultSC(),keepNotMatching=TRUE)} also elements
of \code{mySC} not present in \code{defaultSC()} are taken (no warnings).
}
\seealso{
\code{\link{setParams}}, \code{\link{defaultOpts}}
}
\author{
Wolfgang Konen (\email{wolfgang.konen@th-koeln.de}) THK, 2018
}
