% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCIApathfinder.R
\name{get_series_info}
\alias{get_series_info}
\title{Get image series information}
\usage{
get_series_info(collection = NULL, patient_id = NULL,
  study_instance_uid = NULL, series_instance_uid = NULL,
  modality = NULL, body_part_examined = NULL,
  manufacturer_model_name = NULL, manufacturer = NULL)
}
\arguments{
\item{collection}{TCIA collection name. To get a list of available collection
names, call \code{\link{get_collection_names}}. If \code{collection} is \code{NULL}, information
for all relevant collections will be returned.}

\item{patient_id}{Patient ID. To get a list of available patient IDs, call \code{\link{get_patient_info}}.
If \code{patient_id} is \code{NULL}, information for all relevant patients will be returned.}

\item{study_instance_uid}{Study instance UID. If \code{study_instance_uid} is \code{NULL}, information
for all relevant study instance UIDs will be returned. To get available study instance UIDs, call \code{\link{get_studies_in_collection}},
\code{\link{get_patient_studies}}, or \code{\link{get_new_studies_in_collection}}.}

\item{series_instance_uid}{Series instance UID. To get a list of available series instance UIDs, call
this function leaving out parameter \code{series_instance_uid}. If \code{series_instance_uid} is \code{NULL},
information for all relevant series will be returned.}

\item{modality}{Modality name. To get a list of available modality names, call \code{\link{get_modality_names}}
or see \href{https://wiki.cancerimagingarchive.net/display/Public/DICOM+Modality+Abbreviations}{DICOM Modality Abbreviations}.
If \code{modality} is \code{NULL}, information for all relevant modalities will be returned.}

\item{body_part_examined}{Body part name. To get a list of available body part names, call
\code{\link{get_body_part_names}}. If \code{body_part_examined} is \code{NULL}, information
for all relevant body parts will be returned. IMPORTANT: a bug in this query key has been observed in the TCIA API.
If queries using this key return zero results, try removing this parameter.}

\item{manufacturer_model_name}{Manufacturer model name. To get a list of available model names, call
this function leaving out parameter \code{manufacturer_model_name}. If \code{manufacturer_model_name} is \code{NULL},
information for all relevant model names will be returned.}

\item{manufacturer}{Manufacturer name. To get a list of available manufacturer names, call
\code{\link{get_manufacturer_names}}. If \code{manufacturer} is \code{NULL},
information for all relevant manufacturers will be returned.}
}
\value{
List containing elements:
\itemize{
  \item \code{series}: Data frame with columns representing the contents of a Series object
  as described in \href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API Return Values}
  \item \code{content}: parsed API response content
  \item \code{response}: API response
}
}
\description{
Get image series information
}
\examples{
\dontrun{
get_series_info()
get_series_info(collection = "TCGA-BRCA")
get_series_info(patient_id = "TCGA-OL-A6VO")
get_series_info(modality = "MR", manufacturer = "GE MEDICAL SYSTEMS")
}

}
\seealso{
\code{\link{get_collection_names}},
\code{\link{get_patient_info}},
\code{\link{get_studies_in_collection}},
\code{\link{get_patient_studies}},
\code{\link{get_new_studies_in_collection}},
\code{\link{get_modality_names}},
\code{\link{get_body_part_names}},
\code{\link{get_manufacturer_names}},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+Programmatic+Interface+\%28REST+API\%29+Usage+Guide}{TCIA REST API Usage Guide},
\href{https://wiki.cancerimagingarchive.net/display/Public/TCIA+API+Return+Values}{TCIA API object definitions}
}
