% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_bary14C.R
\name{imagebary14C}
\alias{imagebary14C}
\title{Barycenter of Images according to Cuturi & Doucet (2014)}
\usage{
imagebary14C(images, p = 2, weights = NULL, lambda = NULL, ...)
}
\arguments{
\item{images}{a length-\eqn{N} list of same-size image matrices of size \eqn{(m\times n)}.}

\item{p}{an exponent for the order of the distance (default: 2).}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise,
it should be a length-\eqn{N} vector of nonnegative weights.}

\item{lambda}{a regularization parameter; if \code{NULL} (default), a paper's suggestion
would be taken, or it should be a nonnegative real number.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{init.image}{an initial weight image (default: uniform weight).}
\item{maxiter}{maximum number of iterations (default: 496).}
\item{nthread}{number of threads for OpenMP run (default: 1).}
\item{print.progress}{a logical to show current iteration (default: \code{TRUE}).}
}}
}
\value{
an \eqn{(m\times n)} matrix of the barycentric image.
}
\description{
Using entropic regularization for Wasserstein barycenter computation, \code{imagebary14C}
finds a \emph{barycentric} image \eqn{X^*} given multiple images \eqn{X_1,X_2,\ldots,X_N}.
Please note the followings; (1) we only take a matrix as an image so please
make it grayscale if not, (2) all images should be of same size - no resizing is performed.
}
\examples{
#----------------------------------------------------------------------
#                       MNIST Data with Digit 3
#
# EXAMPLE 1 : Very Small  Example for CRAN; just showing how to use it!
# EXAMPLE 2 : Medium-size Example for Evolution of Output
#----------------------------------------------------------------------
# EXAMPLE 1
data(digit3)
datsmall = digit3[1:2]
outsmall = imagebary14C(datsmall, maxiter=3)

\dontrun{
# EXAMPLE 2 : Barycenter of 100 Images
# RANDOMLY SELECT THE IMAGES
data(digit3)
dat2 = digit3[sample(1:2000, 100)]  # select 100 images

# RUN SEQUENTIALLY
run10 = imagebary14C(dat2, maxiter=10)                   # first 10 iterations
run20 = imagebary14C(dat2, maxiter=10, init.image=run10) # run 40 more
run50 = imagebary14C(dat2, maxiter=30, init.image=run20) # run 50 more

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,3), pty="s")
image(dat2[[sample(100,1)]], axes=FALSE, main="a random image")
image(dat2[[sample(100,1)]], axes=FALSE, main="a random image")
image(dat2[[sample(100,1)]], axes=FALSE, main="a random image")
image(run10, axes=FALSE, main="barycenter after 10 iter")
image(run20, axes=FALSE, main="barycenter after 20 iter")
image(run50, axes=FALSE, main="barycenter after 50 iter")
par(opar)
}

}
\references{
\insertRef{cuturi_fast_2014}{T4transport}
}
\seealso{
\code{\link{bary14C}}
}
\concept{image}
