% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm_gmm03F.R
\name{gmm03F}
\alias{gmm03F}
\title{Ensemble of Gaussian Mixtures with Random Projection}
\usage{
gmm03F(data, k = 2, ...)
}
\arguments{
\item{data}{an \eqn{(n\times p)} matrix of row-stacked observations.}

\item{k}{the number of clusters (default: 2).}

\item{...}{extra parameters including \describe{
\item{nruns}{the number of projections (default: 20).}
\item{lowdim}{target dimension for random projection (default: 5).}
\item{maxiter}{the maximum number of iterations (default: 10).}
\item{usediag}{a logical; covariances are diagonal if \code{TRUE}, or full covariances are returned for \code{FALSE} (default: \code{FALSE}).}
}}
}
\value{
a named list of S3 class \code{T4cluster} containing 
\describe{
\item{cluster}{a length-\eqn{n} vector of class labels (from \eqn{1:k}).}
\item{algorithm}{name of the algorithm.}
}
}
\description{
When the data lies in a high-dimensional Euclidean space, fitting a model-based 
clustering algorithm is troublesome. This function implements an algorithm 
from the reference, which uses an aggregate information from an ensemble of 
Gaussian mixtures in combination with random projection.
}
\examples{
\donttest{
# -------------------------------------------------------------
#            clustering with 'iris' dataset
# -------------------------------------------------------------
## PREPARE
data(iris)
X   = as.matrix(iris[,1:4])
lab = as.integer(as.factor(iris[,5]))

## EMBEDDING WITH PCA
X2d = Rdimtools::do.pca(X, ndim=2)$Y  

## CLUSTERING WITH DIFFERENT K VALUES
cl2 = gmm03F(X, k=2)$cluster
cl3 = gmm03F(X, k=3)$cluster
cl4 = gmm03F(X, k=4)$cluster

## VISUALIZATION
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
plot(X2d, col=lab, pch=19, main="true label")
plot(X2d, col=cl2, pch=19, main="gmm03F: k=2")
plot(X2d, col=cl3, pch=19, main="gmm03F: k=3")
plot(X2d, col=cl4, pch=19, main="gmm03F: k=4")
par(opar)
}

}
\references{
\insertRef{10.5555/3041838.3041862}{T4cluster}
}
\concept{algorithm}
