% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCS_Calculation.R
\name{PCS_Calculation}
\alias{PCS_Calculation}
\title{Calculate PCS (Physical Component Summary) Scores}
\usage{
PCS_Calculation(df)
}
\arguments{
\item{df}{A dataframe containing the questionnaire items with answers.
The dataframe should have specific columns:
\itemize{
\item \strong{EVGFP_rating}: In general, would you say your health is.
\strong{Reference answers}: 1=Excellent, 2=Very good, 3=Good, 4=Fair, 5=Poor.
\item \strong{Moderate_activities}: Moderate activities, such as moving a table, pushing a vacuum cleaner, bowling, or playing golf.
\strong{Reference answers}: 1=Yes, Limited A Lot, 2=Yes, Limited A Little, 3=No, Not Limited At All.
\item \strong{Climb_several_flights}: Climbing several flights of stairs.
\strong{Reference answers}: 1=Yes, Limited A Lot, 2=Yes, Limited A Little, 3=No, Not Limited At All.
\item \strong{Accomplished_less_physically}: Accomplished less than you would like as a result of your physical health.
\strong{Reference answers}: 1=YES, 2=NO.
\item \strong{Limited_in_kind_physically}: Were limited in the kind of work or other activities as a result of your physical health.
\strong{Reference answers}: 1=YES, 2=NO.
\item \strong{Accomplished_less_mentally}: Accomplished less than you would like as a result of any emotional problems (such as feeling depressed or anxious).
\strong{Reference answers}: 1=YES, 2=NO.
\item \strong{Not_careful_mentally}: Didn't do work or other activities as carefully as usual as a result of any emotional problems (such as feeling depressed or anxious).
\strong{Reference answers}: 1=YES, 2=NO.
\item \strong{Pain_interfere}: During the past 4 weeks, how much did pain interfere with your normal work (including both work outside the home and housework)?
\strong{Reference answers}: 1=Not at all, 2=A little bit, 3=Moderately, 4=Quite a bit, 5=Extremely.
\item \strong{Calm}: During the past 4 weeks, have you felt calm and peaceful?
\strong{Reference answers}: 1=All of the Time, 2=Most of the Time, 3=A Good Bit of the Time, 4=Some of the Time, 5=A Little of the Time, 6=None of the Time.
\item \strong{Energy}: During the past 4 weeks, did you have a lot of energy?
\strong{Reference answers}: 1=All of the Time, 2=Most of the Time, 3=A Good Bit of the Time, 4=Some of the Time, 5=A Little of the Time, 6=None of the Time.
\item \strong{Felt_down}: During the past 4 weeks, have you felt downhearted and blue?
\strong{Reference answers}: 1=All of the Time, 2=Most of the Time, 3=A Good Bit of the Time, 4=Some of the Time, 5=A Little of the Time, 6=None of the Time.
\item \strong{Social_time}: During the past 4 weeks, how much of the time has your physical health or emotional problems interfered with your social activities (like visiting with friends, relatives, etc)?
\strong{Reference answers}: 1=All of the Time, 2=Most of the Time, 3=Some of the Time, 4=A Little of the Time, 5=None of the Time.
}}
}
\value{
A dataframe containing the calculated PCS scores.
}
\description{
This function calculates the Physical Component Summary (PCS) scores
based on a set of specific questionnaire items related to physical
and mental health domains. It requires a dataframe containing the
required columns with valid answer ranges, and outputs a dataframe with
PCS scores.
}
\examples{
set.seed(123)

sample_names <- c("xiaoming", "xiaohong", "xiaohua")

df <- data.frame(
  row.names = sample_names,
  EVGFP_rating = sample(1:5, 3, replace = TRUE),
  Moderate_activities = sample(1:3, 3, replace = TRUE),
  Climb_several_flights = sample(1:3, 3, replace = TRUE),
  Accomplished_less_physically = sample(1:2, 3, replace = TRUE),
  Limited_in_kind_physically = sample(1:2, 3, replace = TRUE),
  Accomplished_less_mentally = sample(1:2, 3, replace = TRUE),
  Not_careful_mentally = sample(1:2, 3, replace = TRUE),
  Pain_interfere = sample(1:5, 3, replace = TRUE),
  Calm = sample(1:6, 3, replace = TRUE),
  Energy = sample(1:6, 3, replace = TRUE),
  Felt_down = sample(1:6, 3, replace = TRUE),
  Social_time = sample(1:5, 3, replace = TRUE)
)

PCS_output <- PCS_Calculation(df)
PCS_output
}
\references{
Tucker G, Adams R, Wilson D. New Australian population scoring coefficients
for the old version of the SF-36 and SF-12 health status questionnaires.
Qual Life Res. 2010 Sep;19(7):1069-76. doi: 10.1007/s11136-010-9658-9.
Epub 2010 May 4. Erratum in: Qual Life Res. 2010 Sep;19(7):1077. PMID: 20440565.
}
