% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidimsvc.R
\name{hidimsvc}
\alias{hidimsvc}
\title{hidimsvc
Survival analysis on high dimensional by creating batches of variables}
\usage{
hidimsvc(m, n, batchsize, siglevel, ID, OS, Death, PFS, Prog, data)
}
\arguments{
\item{m}{Starting column number form where study variables of high dimensional data will get selected.}

\item{n}{Ending column number till where study variables of high dimensional data will get selected.}

\item{batchsize}{Number of variables to be consider at time while running function (maximum batch size should not be greater than one third of the total number of high dimensional variables)}

\item{siglevel}{Level of significance pre-determined by the user}

\item{ID}{Column name of subject ID, a string value. i.e. "id"}

\item{OS}{Column name of survival duration event, a string value. i.e. "os"}

\item{Death}{Column name of survival event, a string value. i.e "death"}

\item{PFS}{Column name of progression free survival duration, a string value. i.e "pfs"}

\item{Prog}{Column name of progression event, a string value. i.e "prog"}

\item{data}{High dimensional data containing the survival, progression and genomic observations.}
}
\value{
Estimate values of significant variables/DEGs on considering Death with Progression

Estimate values of significant variables/DEGs on considering Death without Progression

List of variable/DEGs considering Death with Progression

List of variable/DEGs considering Death without Progression

Estimates data for the DEGs/Variables found common between significant DEGs from data having death due to progression and data showing death without progression"

List of variable/DEGs found common between significant DEGs from data having death due to progression and data showing death without progression"
}
\description{
Survival analysis on high dimensional data by creating batches of covariates
}
\details{
hidimsvc function fits Univarate Cox Proportinal Hazard models by considering each variables at a time. Then it filters out study variables having P-value < siglevel(significance level taken as input from user).
Once by survival and survival eevent and another by progression and progression events.
Secondly, it merges the commom sigificant variables from both OS and PFS analysis and creates a
new data frame which contains columns, 'ID','OS','Death','PFS','Prog','Status' and observations
of common significant variables (which are supposed to be leading to death given they leads to progression of cancer
as well as accounts for competing risks)
Further, it lists the common variables names and outs corresponding results in .csv format by default in user's current
working directory.

It works similary to HiDimSurv unlike it creates batches of decided study vriables by user to make the analysis less time consuming.

hidimsvc(m1,m2,batchsize,siglevel,data),

1) Subject ID column should be named as 'ID'.

2) OS column must be named as 'OS'.

3) Death status/event column should be named as 'Death'.

4) Progression Fress Survival column should be named as 'PFS'.

5) Progression event column should be named as 'Prog'.

OSDeathcoeff - A data frame containing HR estimates and p-values for study variables on fitting univariate CoxPh on OS and Survival event.

PFSProgcoeff - A data frame containg HR estimates and p-values for study variables on fitting univariate CoxPh on PFS and Progression event.

namevect - List of all the study variable names.

significantOSDeathgenes - A data frame containing HR estimates and p-values for significant study variables.

significantPFSProggenes - A data frame containing HR estimates and p-values for significant study variables

commongenes - A data frame containing estimated values of significant study variables found common from significant study variables
on fitting CoxPh on survival and progression times and events.

odnames - List of significant variables on fitting CoxPh using survival and survival event.

ppnames - List of significant variables on fitting CoxPh using progression and progression event.

cvar - List of common significant study variables on fitting CoxPh on survival and progression, times and events.

commondata - A data out which contains the clinical observations and observations on commongenes variables.
}
\examples{
##
data(hnscc)
hidimsvc(7,105,5,0.05,ID="id",OS="os",Death="death",PFS="pfs",Prog="prog",hnscc)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Congdon, P. (2014). Applied bayesian modelling (Vol. 595). John Wiley & Sons.

Banerjee, S., Vishwakarma, G. K., & Bhattacharjee, A. (2019). Classification Algorithm for
High Dimensional Protein Markers in Time-course Data. arXiv preprint arXiv:1907.12853.
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
