% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msd2acf.R
\name{msd2acf}
\alias{msd2acf}
\title{Convert mean square displacement of positions to autocorrelation of increments.}
\usage{
msd2acf(msd)
}
\arguments{
\item{msd}{Length-\code{N} MSD vector, i.e., excluding \code{x_0} which is assumed to be zero.}
}
\value{
Length-\code{N} autocorrelation vector.
}
\description{
Converts the mean squared displacement (MSD) of a stationary increments sequence \verb{x = (x_0, x_1, ..., x_N)} positions to the autocorrelation of the corresponding increments \verb{dx = (x_1 - x_0, ..., x_N - x_(N-1))}.
}
\examples{
# autocorrelation of fBM increments
msd2acf(msd = fbm_msd(tseq = 0:10, H = .3))
}
