% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aim_batting.R
\name{aim.rule.batting}
\alias{aim.rule.batting}
\title{The main AIM-Rule-BATTing function}
\usage{
aim.rule.batting(y, x, censor.vec = NULL, trt.vec = NULL, trtref = NULL,
  type, n.boot, des.res = "larger", min.sigp.prcnt = 0.2, mc.iter = 1,
  mincut = 0.1, pre.filter = NULL, filter.method = NULL)
}
\arguments{
\item{y}{data frame of the response variable.}

\item{x}{data frame of predictors, each column of which corresponds to a variable.}

\item{censor.vec}{data frame indicating censoring for survival data. For binary or continuous data, set censor.vec <- NULL.}

\item{trt.vec}{data frame indicating whether or not the patient was treated. For the pronostic case, set trt.vec <- NULL.}

\item{trtref}{code for treatment arm.}

\item{type}{data type - "c" - continuous , "b" - binary, "s" - time to event  - default = "c".}

\item{n.boot}{number of bootstraps in bootstrapping step.}

\item{des.res}{the desired response. "larger": prefer larger response; "smaller": prefer smaller response.}

\item{min.sigp.prcnt}{desired proportion of signature positive group size.}

\item{mc.iter}{# of iterations for the MC procedure to get a stable "best number of predictors".}

\item{mincut}{the minimum cutting proportion for the binary rule at either end. It typically is between 0 and 0.2. It is the parameter in the functions of AIM package.}

\item{pre.filter}{NULL, no prefiltering conducted;"opt", optimized number of predictors selected; An integer: min(opt, integer) of predictors selected.}

\item{filter.method}{NULL, no prefiltering, "univariate", univariate filtering; "glmnet", glmnet filtering; "unicart", CART filtering (only for prognostic case).}
}
\value{
A list of containing variables in signature and their thresholds.
}
\description{
This function first uses AIM to get the candidate rules and then applies Sequential BATTing to get the best rule(s).
}
