% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSubTite.R
\name{GetSubTite}
\alias{GetSubTite}
\title{Gives the subgroup specific optimal dose vector.}
\usage{
GetSubTite(
  Y,
  I,
  Doses,
  Groups,
  Include = rep(1, length(Y)),
  ID,
  cohort,
  Conservative,
  T1,
  Target,
  Upper,
  Dose,
  meanmu,
  meanslope,
  MeanInts,
  MeanSlopes,
  varint,
  varbeta,
  phetero,
  Borrow,
  B
)
}
\arguments{
\item{Y}{Vector containing observed event or censoring times.}

\item{I}{Vector containing event indicators (1 if patient experiences an event for a patient).}

\item{Doses}{Vector containing numerical doses assigned to patients in the trial.}

\item{Groups}{Vector containing group assignment of patients, 1 is baseline group.}

\item{Include}{Binary vector indicating whether each patient record should be included in the decision making process.}

\item{ID}{Vector of patient IDs. Can be numeric or character valued.}

\item{cohort}{Number of patients needed to be assigned at a dose level prior to escalation.}

\item{Conservative}{Binary Indicator of Whether conservative escalation, i.e. not allowing escalation until cohort patients have been fully evaluated at the highest tried dose level.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability vector at time T1.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{meanmu}{Prior mean for baseline intercept.}

\item{meanslope}{Prior mean for baseline slope.}

\item{MeanInts}{Vector of prior means for the group specific intercept parameters.}

\item{MeanSlopes}{Vector of prior means for the group specific slope parameters.}

\item{varint}{Prior variance for the intercept parameters.}

\item{varbeta}{Prior variance for the slope parameters.}

\item{phetero}{Prior probability of heterogeneous subgroups.}

\item{Borrow}{Parameter to specify subgroup borrowing/clustering. 0=No borrowing, 1=Borrowing but no clustering, 2=Borrowing and clustering.}

\item{B}{Number of Iterations to run for MCMC}
}
\value{
Returns a list with two objects, a vector of optimal doses for each subgroup and matrix of posterior toxicity probabilities at each dose level within each subgroup.
}
\description{
Returns a list containing the optimal doses to enroll each subgroup at and the subgroups that should have their accrual suspended temporarily.
}
\examples{
T1=28 ##Reference time for toxicity
Target=rep(.3,2) ##Target toxicity probability
Upper=rep(.95,2) ##Upper cutoffs for excessive toxicity
##How many patients in each subgroup have been assigned at each dose level?
cohort=3 ##Cohort size required for escalation
Conservative = 1 ##Conservative escalation
##Only can escalate with a fully evaluated cohort at the highest dose level.
##Matrix of umber of patients tried or fully evaluated at each dose level.
##Hyperparameters
meanmu=-0.4467184 ##Common Intercept hypermean
meanslope= 0.8861634 ##Common slope hypermean
MeanInts = -0.5205379 ##Group Intercept hypermeans
MeanSlopes = 0.1888923 ##Group slope hyperneabs
varint=5 #Prior Variance of the intercept betas
varbeta=1 ##Prior Variance of slope betas
phetero=.9 ##Prior Probability of hetergeneity
Borrow=0 ##Borrowing specification, 0=none, 1=some, 2=clustering.
B=5000 ##Number of iterations
Borrow=2
Y=c(28,26,29,28,29,5,1)
RawDose=c(350,420,530,660,825)
Dose=(RawDose-mean(RawDose))/sd(RawDose)
I <- c(0,0,0,0,0,0,0)
Doses <- rep(2,7)
Groups <- c(0,1,1,0,0,1,1)
Include <- rep(1,7)
ID=1:length(Y)
Z=GetSubTite(Y, I,Doses, Groups, Include,ID,cohort, Conservative,
T1,Target,  Upper, Dose,  meanmu, meanslope,
 MeanInts,  MeanSlopes ,varint,varbeta,phetero, Borrow,B)
Z
}
\references{
[1] Chapple and Thall (2017), Subgroup Specific Dose Finding in Phase I Clinical Trials Based on Time to Toxicity Within a Fixed Follow Up Period.
}
