% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat.repair.R
\name{strat.repair}
\alias{strat.repair}
\title{Remove instantaneous deposits and add thickness in hiatuses}
\usage{
strat.repair(
  dt,
  gap = list(),
  fill = list(),
  clean = F,
  left.side = T,
  left.norm = T
)
}
\arguments{
\item{dt}{depth or time}

\item{gap}{list}

\item{fill}{list}

\item{clean}{whether to set the points in fills as NA}

\item{left.side}{l}

\item{left.norm}{l}
}
\description{
Remove instantaneous deposits, or 'fills', (e.g. turbidites) and
add thickness estimated to be lost, or gaps' (i.e. hiatuses).
}
\examples{
dt <- as.list(tie.points.example[,2:6])

gap  <- list()
fill <- list()

gap$Charce    <- data.frame(dt = c(370,400), span = c(50,10))
gap$El.Porton <- data.frame(dt = -400, span = 30)

fill$Charce     <- data.frame(l = 63, r = 65)
fill$El.Porton  <- data.frame(l = c(-530), r = c(-630))
fill$Frielingen <- data.frame(l = 20, r = 30)

strat.repair(dt, gap, fill)

}
