% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{distUnitk}
\alias{distUnitk}
\title{Squared Euclidean distances of the unit k.}
\usage{
distUnitk(X, k, tore, toreBound)
}
\arguments{
\item{X}{matrix representing the spatial coordinates.}

\item{k}{the unit index to be used.}

\item{tore}{an optional logical value, if we are considering the distance on a tore. See Details.}

\item{toreBound}{an optional numeric value that specify the length of the tore.}
}
\value{
a vector of length \eqn{N} that contains the distances from the unit \eqn{k} to all other units.
}
\description{
Calculate the squared Euclidean distance from unit \eqn{k} to the other units.
}
\details{
Let \eqn{\mathbf{x}_k,\mathbf{x}_l} be the spatial coordinates of the unit \eqn{k,l \in U}. The classical euclidean distance is given by

\deqn{d^2(k,l) = (\mathbf{x}_k - \mathbf{x}_l)^\top (\mathbf{x}_k - \mathbf{x}_l). }

When the points are distributed on a \eqn{N_1 \times N_2} regular grid of \eqn{R^2}.
It is possible to consider the units like they were placed on a tore. It can be illustrated by Pac-Man passing through the wall to get away from ghosts. Specifically,
we could consider two units on the same column (resp. row) that are on the opposite have a small distance,

\deqn{ d^2_T(k,l) = min( (x_{k_1} - x_{l_1})^2,
                      (x_{k_1} + N_1 - x_{l_1})^2,
                      (x_{k_1} - N_1 - x_{l_1})^2) +}
\deqn{ min( (x_{k_2} - x_{l_2})^2,
                      (x_{k_2} + N_2 - x_{l_2})^2,
                      (x_{k_2} - N_2 - x_{l_2})^2).}

The option \code{toreBound} specify the length of the tore in the case of \eqn{N_1 = N_2 = N}. 
It is omitted if the \code{tore} option is equal to \code{FALSE}.
}
\examples{
  N <- 5
  x <- seq(1,N,1)
  X <- as.matrix(expand.grid(x,x))
  distUnitk(X,k = 2,tore = TRUE,toreBound = 5)
  distUnitk(X,k = 2,tore = FALSE,toreBound = -1)
}
\seealso{
\code{\link[stats]{dist}}.
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
