# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C bound
#'
#' @description This function is returning the number of unit that we need such that some conditions are fulfilled. See Details
#' 
#' @param pik vector of the inclusion probabilities.
#' 
#' @details
#' The function is computing the number of unit \eqn{K} that we need to add such that the following conditions are fulfilled :
#'
#' \itemize{
#' \item \eqn{\sum_{k = 1}^K \pi_k \geq 1}
#' \item \eqn{\sum_{k = 1}^K 1 - \pi_k \geq 1}
#' \item Let \eqn{c} be the constant such that \eqn{\sum_{k = 2}^K min(c\pi_k,1) = n }, we must have that \eqn{ \pi_1 \geq 1- 1/c}
#' }
#' 
#' @return An integer value, the number of units that we need to respect the constraints.
#'
#' @seealso \code{\link{osod}}
#'
#' @author Raphael Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' 
#' @export
c_bound <- function(pik) {
    .Call(`_StratifiedSampling_c_bound`, pik)
}

#' @title Calibration using raking ratio  
#'
#' @description This function is inspired by the function \code{\link[sampling:calib]{calib}} of the package sampling. It computes the g-weights of the calibration estimator.
#' 
#' @param Xs A matrix of calibration variables.
#' @param d A vector, the initial weights.
#' @param total A vector that represents the initial weights.
#' @param q A vector of positive value that account for heteroscedasticity.
#' @param max_iter An integer, the maximum number of iterations. Default = 500.
#' @param tol A scalar that represents the tolerance value for the algorithm. Default = 1e-9.
#'
#' @details
#' More details on the different calibration methods can be read in Tillé Y. (2020).
#'
#' @return A vector, the value of the g-weights.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#'
#' @references Tillé, Y. (2020). \emph{Sampling and estimation from finite populations}. Wiley, New York
#' 
#' @export
calibRaking <- function(Xs, d, total, q, max_iter = 500L, tol = 1e-9) {
    .Call(`_StratifiedSampling_calibRaking`, Xs, d, total, q, max_iter, tol)
}

#' @title Disjunctive
#'
#' @description
#' This function transforms a categorical vector into a matrix of indicators.
#'
#' @param strata A vector of integers that represents the categories.
#'
#' @return A matrix of indicators.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @examples
#' strata <- rep(c(1,2,3),each = 4)
#' disj(strata)
#'
#' @export
disj <- function(strata) {
    .Call(`_StratifiedSampling_disj`, strata)
}

#' @title Number of categories
#'
#' @description
#' This function returns the number of factor in each column of a categorical matrix.
#'
#' @param Xcat A matrix of integers that contains categorical vector in each column.
#'
#' @return A row vector that contains the number of categories in each column.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @export
#' 
#' @examples
#' Xcat <-  matrix(c(sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE)),ncol = 3)
#' ncat(Xcat)
ncat <- function(Xcat) {
    .Call(`_StratifiedSampling_ncat`, Xcat)
}

#' @title Disjunctive for matrix  
#'
#' @description
#' This function transforms a categorical matrix into a matrix of indicators variables.
#'
#' @param strata A matrix of integers that contains categorical vector in each column.
#'
#' @return A matrix of indicators.
#'
#' @author Raphaël Jauslin \email{raphael.jauslin@@unine.ch}
#' 
#' @examples
#' Xcat <-  matrix(c(sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE),
#'             sample(x = 1:6, size = 100, replace = TRUE)),ncol = 3)
#' disjMatrix(Xcat)
#'
#' @export
disjMatrix <- function(strata) {
    .Call(`_StratifiedSampling_disjMatrix`, strata)
}

#' @title Inclusion Probabilities
#'
#' @description Computes first-order inclusion probabilities from a vector of positive numbers.
#' 
#' @param x vector of positive numbers.
#' @param n sample size (could be a positive real value).
#' 
#' @details
#' The function is implemented in C++ so that it can be used in the code of other C++ functions. The implementation is based on the function  \code{\link[sampling]{inclusionprobabilities}} of the package sampling.
#'
#' @return A vector of inclusion probabilities proportional to \code{x} and such that the sum is equal to the value \code{n}.
#'
#' @author Raphael Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @seealso \code{\link[sampling]{inclusionprobabilities}}
#' 
#' @examples
#' 
#' x <- runif(100)
#' pik <- inclprob(x,70)
#' sum(pik)
#' 
#' @export
inclprob <- function(x, n) {
    .Call(`_StratifiedSampling_inclprob`, x, n)
}

#' @title One-step One Decision sampling method
#'
#' @description This function implements the One-step One Decision method. It can be used using equal or unequal inclusion probabilities. The method is particularly useful for selecting a sample from a stream. 
#' 
#' @param pikr A vector of inclusion probabilities.
#' 
#' @details
#' 
#' The method sequentially transforms the vector of inclusion probabilities into a sample whose values are equal to 0 or 1. The method respects the inclusion probabilities and can
#' handle equal or unequal inclusion probabilities.
#' 
#' The method does not take into account the whole vector of inclusion probabilities by having a sequential implementation. This means that the method is fast and can be implemented in a flow.
#' 
#' @return A vector with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for rejected units.
#'
#' @author Raphael Jauslin \email{raphael.jauslin@@unine.ch}
#'
#' @seealso \code{\link{c_bound}}
#' 
#' @examples
#' 
#' N <- 1000
#' n <- 100
#' pik <- inclprob(runif(N),n)
#' s <- osod(pik)
#' 
#' @export
osod <- function(pikr) {
    .Call(`_StratifiedSampling_osod`, pikr)
}

