% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p3.R
\name{p3}
\alias{p3}
\title{simulate Poisson point process}
\usage{
p3(rate, from, to, n = NULL)
}
\arguments{
\item{rate}{strictly positive number, rate of events (avg events per unit)}

\item{from}{lowest boundary of observed interval}

\item{to}{upper boundary of observed interval}

\item{n}{integer of NULL (default). Number of events to return. If NULL, the number is random and determined by the rate parameter}
}
\value{
a numeric vector with timing/location of events.
}
\description{
Simulates events in the interval \code{from} to \code{to} based on a Poisson point process with rate \code{rate}. If the parameter \code{n} is used, the number of fossils is conditioned to be \code{n}
In the context of paleontology, these events can be interpreted as fossil occurrences or first/last occurrences of species. In this case, the rate is the average number of fossil occurrences (resp first/last occurrences) per unit
}
\examples{

# for fossil occ.
x = p3(rate = 5, from = 0, to = 1) # 5 fossil occurrences per myr on avg.
hist(x, xlab = "Time (Myr)", ylab = "Fossil Occurrences" )

x = p3(rate = 3, from = 0, to = 4)
hist(x, main = paste0(length(x), " samples")) # no of events is random

x = p3(rate = 3, from = 0, to = 4, n = 10)
hist(x, main = paste0(length(x), " samples")) # no of events is fixed to n

# see also
#vignette("event_data")
# for details on usage and applications to paleontology


}
\seealso{
\code{\link[=p3_var_rate]{p3_var_rate()}} for the variable rate implementation
}
