% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_sols_xml.R
\name{gen_sols_xml}
\alias{gen_sols_xml}
\title{Generate STICS sols xml file from a template or an input file}
\usage{
gen_sols_xml(
  file,
  param_df,
  template = NULL,
  stics_version = "latest",
  sols_in_file = lifecycle::deprecated(),
  sols_param = lifecycle::deprecated(),
  sols_out_file = lifecycle::deprecated(),
  sols_nb = lifecycle::deprecated()
)
}
\arguments{
\item{file}{Path (including name) of the sols file to generate.}

\item{param_df}{A table (df, tibble) containing the values of the parameters
to use (see details)}

\item{template}{Path of a soil xml file to be used as a template. Optional,
if not provided, the function will use a standard template depending on
the STICS version.}

\item{stics_version}{Name of the STICS version. Optional, used if the \code{file}
argument is not provided. In this case the function uses a standard template
associated to the STICS version.}

\item{sols_in_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{sols_in_file} is no
longer supported, use \code{template} instead.}

\item{sols_param}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{sols_param} is no
longer supported, use \code{param_df} instead.}

\item{sols_out_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{sols_out_file} is no
longer supported, use \code{file} instead.}

\item{sols_nb}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{sols_nb} is no
longer supported, it is now computed in the function.}
}
\value{
an invisible xml_document object
}
\description{
Generate STICS sols xml file from a template or an input file
}
\details{
Please see \code{get_stics_versions_compat()} for the full list of
STICS versions that can be used for the argument \code{stics_version}.

\code{param_df} is a \code{data.frame} with the following format:\tabular{lrrrrrrr}{
   Soil_name \tab argi \tab norg \tab calc \tab pH \tab albedo \tab q0 \tab epc_1 \cr
   USM_T1 \tab 20.35000 \tab 0.100 \tab 0.52 \tab 8.23 \tab 0.22 \tab 9.630 \tab 30 \cr
   LF1 \tab 17.00000 \tab 1.900 \tab 0.00 \tab 6.70 \tab 0.22 \tab 9.360 \tab 30 \cr
   LF2 \tab 17.00000 \tab 1.800 \tab 0.00 \tab 6.70 \tab 0.22 \tab 9.360 \tab 30 \cr
   LAP \tab 22.00000 \tab 2.000 \tab 0.00 \tab 6.50 \tab 0.22 \tab 9.760 \tab 25 \cr
   LAS \tab 24.05000 \tab 2.500 \tab 30.00 \tab 8.00 \tab 0.22 \tab 9.928 \tab 30 \cr
   LA0 \tab 30.00675 \tab 2.300 \tab 0.50 \tab 7.50 \tab 0.22 \tab 10.400 \tab 30 \cr
   LC0 \tab 22.38750 \tab 2.000 \tab 10.00 \tab 7.90 \tab 0.22 \tab 9.792 \tab 25 \cr
   Vill09 \tab 25.00000 \tab 0.101 \tab 0.40 \tab 7.90 \tab 0.22 \tab 10.000 \tab 30 \cr
   Vill10 \tab 14.30000 \tab 0.099 \tab 1.50 \tab 8.20 \tab 0.22 \tab 9.144 \tab 30 \cr
   Vill11 \tab 11.80000 \tab 0.100 \tab 0.00 \tab 7.30 \tab 0.22 \tab 8.944 \tab 30 \cr
   Vill12 \tab 14.30000 \tab 0.091 \tab 0.60 \tab 8.30 \tab 0.22 \tab 9.144 \tab 30 \cr
   Vill13 \tab 16.80000 \tab 0.088 \tab 0.20 \tab 7.80 \tab 0.22 \tab 9.344 \tab 30 \cr
   Vill14 \tab 15.10000 \tab 0.095 \tab 1.30 \tab 7.90 \tab 0.22 \tab 9.208 \tab 30 \cr
}


The first column gives the soil name, all following
columns give the parameter values to put in the sols.xml file for each
soil row.

The first column name must contain the keyword Soil or soil or SOIL as
a prefix to be detected (as shown in the table extract above).

If not given (the default, \code{NULL}), the function returns the template as is.
}
\examples{

xl_path <- download_usm_xl(file = "inputs_stics_example.xlsx")

sols_param_df <- read_params_table(file = xl_path, sheet_name = "Soils")
gen_sols_xml(file = file.path(tempdir(), "sols.xml"),
param_df = sols_param_df)

}
