% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download example USMs}
\usage{
download_data(
  out_dir = tempdir(),
  example_dirs = NULL,
  stics_version = "latest",
  dir = lifecycle::deprecated(),
  version_name = lifecycle::deprecated()
)
}
\arguments{
\item{out_dir}{Path of the directory where to download the data}

\item{example_dirs}{List of use case directories names (optional)}

\item{stics_version}{Name of the STICS version. Optional, by default the
latest version returned by get_stics_versions_compat() is used.}

\item{dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{dir} is no
longer supported, use \code{out_dir} instead.}

\item{version_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{file_path} is no
longer supported, use \code{file} instead.}
}
\value{
The path to the folder where data have been downloaded
}
\description{
Download locally the example data from the
\href{https://github.com/SticsRPacks/data}{data repository} in the SticsRPacks
organisation.
}
\examples{

# Getting all data
download_data()

download_data(example_dirs = "study_case_1")

# Getting data for a given example : study_case_1 and a given version
download_data(example_dirs = "study_case_1", stics_version = "V9.0")

}
