% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_analysis_fnxs.R
\name{analyze.stick.data.batch}
\alias{analyze.stick.data.batch}
\title{Analyze batch data generated by \code{\link{sim.fit.stick.data.batch}}}
\usage{
analyze.stick.data.batch(mut.vals, coe.vals, sig.vals, inpath, fit.methods,
  d.range, d.true, relative, coes)
}
\arguments{
\item{mut.vals}{Vector of number of mutations to simulate}

\item{coe.vals}{Vector of stickbreaking coefficients to analyze}

\item{sig.vals}{Vector of sigma values to analyze}

\item{inpath}{The path to read input files from. Generally same as \code{outpath} from
\code{\link{sim.fit.stick.data.batch}}.}

\item{fit.methods}{Vector of all methods of estimating d to then fit model and output results.
Accepts "MLE", "RDB", "max", "seq", "RDB.all" and "All". "All" does all methods. Default is "seq". Case sensitive.
Note you should use same fit.methods (or a subset of) as used when generating data in}

\item{d.range}{Search range for d.}

\item{d.true}{The distance to the boundary (d) used in simulations
\code{\link{sim.fit.stick.data.batch}}.}

\item{relative}{\code{TRUE/FALSE}. Should bias and rMSE be divided by parameter value to make them relative values?}

\item{coes}{Vector of stickbreaking coefficients for each mutation}
}
\value{
List: \cr
[[1]] \code{error.table} A data frame with the parametric conditions and the failure rate, bias and rMSE
for the parameters d, the stickbreaking coefficients, and sigma. \cr
[[2]] \code{seq.method.props} A data frame with the proportion of sequential estimates coming from the MLE
RDB and max methods for each parametric condition. If "seq" is not among the fit.methods, the dataframe is
returned but empty.
}
\description{
Analyze batch data generated by \code{\link{sim.fit.stick.data.batch}}
}
\details{
This function assesses bias and relative root mean squared error (rMSE) from the data generated by
\code{\link{sim.fit.stick.data.batch}}. It also determines the failure rate for each method.
An estimate is considered invalid (a failure) when it does not fall in the range \code{d.range}. The
function also returns the data frame \code{seq.method.props} that indicates for the sequential method,
what proportion of the estimates come from the MLE, RDB and max methods. If "seq" is not part of
fit.methods (and if fit.methods <- "All" then it is), this dataframe is empty but still returned.
}

