% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{alpha012_to_RandEff}
\alias{alpha012_to_RandEff}
\title{Correlation structure: transform alpha to random effects}
\usage{
alpha012_to_RandEff(alpha012, sigResid = NULL, sigMarg = NULL)
}
\arguments{
\item{alpha012}{A vector or a list of length 3. Each list element must have
the same dimension.}

\item{sigResid}{Residual standard deviation on individual level. Either
residual sd or marginal sd needs to be specified.}

\item{sigMarg}{Marginal standard deviation on individual level. Either
residual sd or marginal sd needs to be specified.}
}
\value{
a list containing four named elements (possibly matrices):
random cluster intercept `tau`, random time effect `gamma`, random subject
intercept and residual standard deviation
}
\description{
Correlation structure: transform alpha to random effects
}
\examples{
alpha012_to_RandEff(alpha012=c(.1,.1,.1), sigMarg=1)
alpha012_to_RandEff(alpha012=c(.1,.1,.1), sigResid=.9486833)

## The function is vectorised:
alpha012_to_RandEff(alpha012=list(matrix(c(0,.1,.1,.2), 2, 2),
                                  matrix(c(0,0,.1,.2) , 2, 2),
                                  matrix(c(0,0,.2,.2) , 2, 2)),
                    sigMarg=1)

}
