% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/splitdata.R
\name{splitdata}
\alias{splitdata}
\title{Split modeling data into test and train set}
\usage{
splitdata(data, fraction, seed = NULL)
}
\arguments{
\item{data}{a matrix, data.frame or data.table}

\item{fraction}{proportion of observations that should go in the train set}

\item{seed}{an integer value}
}
\value{
a list with two elements: train and test set
}
\description{
Takes in data, fraction (for train set) and seed, and returns train and test set
}
\details{
An essential task before doing modeling is to split the modeling data into
 train and test sets. \code{splitdata} is built for this task and returns a list
 with train and test sets, which can be picked using the code given in example.

 \code{fraction} corresponds to the train dataset, while the rest of the
 observations go to the test dataset. If the user wants to generate the same
 test and train dataset everytime, he should specify a \code{seed} value.
}
\examples{
# A 'data.frame'
df <- data.frame(x = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
                 y = c('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'),
                 z = c(1, 1, 0, 0, 1, 0, 0, 1, 1, 0))

# Split data into train (70\%) and test (30\%)
ltData <- splitdata(data = df, fraction = 0.7, seed = 123)
trainData <- ltData$train
testData <- ltData$test
}
\author{
Akash Jain
}
\seealso{
\code{\link{actvspred}}, \code{\link{mape}}, \code{\link{accuracy}},
          \code{\link{auc}}, \code{\link{iv}}, \code{\link{ks}}
}

