% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_rep_check_by_density.R
\name{p_rep_check_by_density}
\alias{p_rep_check_by_density}
\title{Generate a spatial layout of checks by density: p rep design with checks}
\usage{
p_rep_check_by_density(n.row, n.col, check.density = 0.05, by.density)
}
\arguments{
\item{n.row}{The row of a retangular grid}

\item{n.col}{The column of a retangular grid}

\item{check.density}{The density of the check}

\item{by.density}{The total density of check and p_rep, MUST be a even decimal number after substract the check.density}
}
\value{
A dataframe will return: row.var=row, col.var=col, check=0, single rep; 1, check; else, partial replicated entries
}
\description{
This function generate a check layout in a retangular grid. the check and partial replicated entries are spread by blocksdesign library
}
\examples{
# To produce a 20 by 20 field with check distributed by density=0.35
nr = 20; nc = 20
example.tmp = p_rep_check_by_density(nr, nc, by.density=.35)
fields::quilt.plot(example.tmp, nx=nr, ny=nc)
}
