% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{turinW}
\alias{turinW}
\title{Observation window for Turin urban data.}
\format{
An \code{owin} object. Units are given in metres; the basic image unit is a 250x250 metres pixels.
}
\source{
EEA (2011). Corine land cover 2000 raster data. Technical Report, downloadable at
http://www.eea.europa.eu/data-and-maps/ data/corine-land-cover-2000-raster-1
}
\usage{
turinW
}
\description{
An \code{owin} object with the city border for the Turin dataset.
}
\details{
This observation window is an \code{owin} object created as a binary mask. See \code{?owin} for details.
Examples on the usefulness of the window can be found at the topic \link{turin}.
}
\examples{
data(turinW)
plot(turinW, col=c("red", "white"), main="")
plot(as.im(turin, W=turinW), main="", col=gray(c(0.8,0)), ribbon=FALSE, add=TRUE)

#see examples under the topic "turin"
}
\keyword{datasets}
