% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_tree.R
\docType{methods}
\name{spark.decisionTree}
\alias{spark.decisionTree}
\alias{spark.decisionTree}
\alias{spark.decisionTree,SparkDataFrame,formula-method}
\alias{summary,DecisionTreeRegressionModel-method}
\alias{print.summary.DecisionTreeRegressionModel}
\alias{summary,DecisionTreeClassificationModel-method}
\alias{print.summary.DecisionTreeClassificationModel}
\alias{predict,DecisionTreeRegressionModel-method}
\alias{predict,DecisionTreeClassificationModel-method}
\alias{write.ml,DecisionTreeRegressionModel,character-method}
\alias{write.ml,DecisionTreeClassificationModel,character-method}
\title{Decision Tree Model for Regression and Classification}
\usage{
spark.decisionTree(data, formula, ...)

\S4method{spark.decisionTree}{SparkDataFrame,formula}(data, formula,
  type = c("regression", "classification"), maxDepth = 5, maxBins = 32,
  impurity = NULL, seed = NULL, minInstancesPerNode = 1,
  minInfoGain = 0, checkpointInterval = 10, maxMemoryInMB = 256,
  cacheNodeIds = FALSE, handleInvalid = c("error", "keep", "skip"))

\S4method{summary}{DecisionTreeRegressionModel}(object)

\method{print}{summary.DecisionTreeRegressionModel}(x, ...)

\S4method{summary}{DecisionTreeClassificationModel}(object)

\method{print}{summary.DecisionTreeClassificationModel}(x, ...)

\S4method{predict}{DecisionTreeRegressionModel}(object, newData)

\S4method{predict}{DecisionTreeClassificationModel}(object, newData)

\S4method{write.ml}{DecisionTreeRegressionModel,character}(object, path,
  overwrite = FALSE)

\S4method{write.ml}{DecisionTreeClassificationModel,character}(object, path,
  overwrite = FALSE)
}
\arguments{
\item{data}{a SparkDataFrame for training.}

\item{formula}{a symbolic description of the model to be fitted. Currently only a few formula
operators are supported, including '~', ':', '+', and '-'.}

\item{...}{additional arguments passed to the method.}

\item{type}{type of model, one of "regression" or "classification", to fit}

\item{maxDepth}{Maximum depth of the tree (>= 0).}

\item{maxBins}{Maximum number of bins used for discretizing continuous features and for choosing
how to split on features at each node. More bins give higher granularity. Must be
>= 2 and >= number of categories in any categorical feature.}

\item{impurity}{Criterion used for information gain calculation.
For regression, must be "variance". For classification, must be one of
"entropy" and "gini", default is "gini".}

\item{seed}{integer seed for random number generation.}

\item{minInstancesPerNode}{Minimum number of instances each child must have after split.}

\item{minInfoGain}{Minimum information gain for a split to be considered at a tree node.}

\item{checkpointInterval}{Param for set checkpoint interval (>= 1) or disable checkpoint (-1).
Note: this setting will be ignored if the checkpoint directory is not
set.}

\item{maxMemoryInMB}{Maximum memory in MB allocated to histogram aggregation.}

\item{cacheNodeIds}{If FALSE, the algorithm will pass trees to executors to match instances with
nodes. If TRUE, the algorithm will cache node IDs for each instance. Caching
can speed up training of deeper trees. Users can set how often should the
cache be checkpointed or disable it by setting checkpointInterval.}

\item{handleInvalid}{How to handle invalid data (unseen labels or NULL values) in features and
label column of string type in classification model.
Supported options: "skip" (filter out rows with invalid data),
                   "error" (throw an error), "keep" (put invalid data in
                   a special additional bucket, at index numLabels). Default
                   is "error".}

\item{object}{A fitted Decision Tree regression model or classification model.}

\item{x}{summary object of Decision Tree regression model or classification model
returned by \code{summary}.}

\item{newData}{a SparkDataFrame for testing.}

\item{path}{The directory where the model is saved.}

\item{overwrite}{Overwrites or not if the output path already exists. Default is FALSE
which means throw exception if the output path exists.}
}
\value{
\code{spark.decisionTree} returns a fitted Decision Tree model.

\code{summary} returns summary information of the fitted model, which is a list.
        The list of components includes \code{formula} (formula),
        \code{numFeatures} (number of features), \code{features} (list of features),
        \code{featureImportances} (feature importances), and \code{maxDepth} (max depth of
        trees).

\code{predict} returns a SparkDataFrame containing predicted labeled in a column named
        "prediction".
}
\description{
\code{spark.decisionTree} fits a Decision Tree Regression model or Classification model on
a SparkDataFrame. Users can call \code{summary} to get a summary of the fitted Decision Tree
model, \code{predict} to make predictions on new data, and \code{write.ml}/\code{read.ml} to
save/load fitted models.
For more details, see
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#decision-tree-regression}{
Decision Tree Regression} and
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html#decision-tree-classifier}{
Decision Tree Classification}
}
\note{
spark.decisionTree since 2.3.0

summary(DecisionTreeRegressionModel) since 2.3.0

print.summary.DecisionTreeRegressionModel since 2.3.0

summary(DecisionTreeClassificationModel) since 2.3.0

print.summary.DecisionTreeClassificationModel since 2.3.0

predict(DecisionTreeRegressionModel) since 2.3.0

predict(DecisionTreeClassificationModel) since 2.3.0

write.ml(DecisionTreeRegressionModel, character) since 2.3.0

write.ml(DecisionTreeClassificationModel, character) since 2.3.0
}
\examples{
\dontrun{
# fit a Decision Tree Regression Model
df <- createDataFrame(longley)
model <- spark.decisionTree(df, Employed ~ ., type = "regression", maxDepth = 5, maxBins = 16)

# get the summary of the model
summary(model)

# make predictions
predictions <- predict(model, df)

# save and load the model
path <- "path/to/model"
write.ml(model, path)
savedModel <- read.ml(path)
summary(savedModel)

# fit a Decision Tree Classification Model
t <- as.data.frame(Titanic)
df <- createDataFrame(t)
model <- spark.decisionTree(df, Survived ~ Freq + Age, "classification")
}
}
