% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{tableToDF}
\alias{tableToDF}
\title{Create a SparkDataFrame from a SparkSQL Table}
\usage{
tableToDF(tableName)
}
\arguments{
\item{tableName}{The SparkSQL Table to convert to a SparkDataFrame.}
}
\value{
SparkDataFrame
}
\description{
Returns the specified Table as a SparkDataFrame.  The Table must have already been registered
in the SparkSession.
}
\note{
tableToDF since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
createOrReplaceTempView(df, "table")
new_df <- tableToDF("table")
}
}
