% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\docType{methods}
\name{cume_dist}
\alias{cume_dist}
\alias{cume_dist}
\alias{cume_dist,missing-method}
\title{cume_dist}
\usage{
cume_dist(x = "missing")

\S4method{cume_dist}{missing}()
}
\arguments{
\item{x}{empty. Should be used with no argument.}
}
\description{
Window function: returns the cumulative distribution of values within a window partition,
i.e. the fraction of rows that are below the current row.
}
\details{
N = total number of rows in the partition
  cume_dist(x) = number of values before (and including) x / N

This is equivalent to the \code{CUME_DIST} function in SQL.
}
\note{
cume_dist since 1.6.0
}
\examples{
\dontrun{
  df <- createDataFrame(mtcars)
  ws <- orderBy(windowPartitionBy("am"), "hp")
  out <- select(df, over(cume_dist(), ws), df$hp, df$am)
}
}
\seealso{
Other window_funcs: \code{\link{dense_rank}},
  \code{\link{lag}}, \code{\link{lead}},
  \code{\link{ntile}}, \code{\link{percent_rank}},
  \code{\link{rank}}, \code{\link{row_number}}
}
