% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spades-classes.R
\name{spadesClasses}
\alias{spadesClasses}
\title{Classes defined in SpaDES}
\description{
These S4 classes are defined within \code{SpaDES}. "dot" classes are not exported and
are therefore intended for internal use only.
}
\section{Simulation classes}{

\tabular{ll}{
  \code{\link{simList}} \tab The 'simList' class\cr
  \code{\link{.moduleDeps}} \tab Descriptor object for specifying \code{SpaDES} module dependecies\cr
  \code{\link{.simDeps}} \tab Defines all simulation dependencies for all modules within a \code{SpaDES} simulation\cr
  --------------------------- \tab ------------------------------------------------------------------------------------------ \cr
}
}

\section{Plotting classes - used within \code{Plot}}{


\tabular{ll}{
  New classes\tab \cr
  \code{\link{.spadesPlot}} \tab Main class for \code{Plot} - contains \code{.spadesGrob} and \code{.arrangement} objects\cr
  \code{\link{.spadesGrob}} \tab GRaphical OBject used by SpaDES - smallest unit\cr
  \code{\link{.arrangement}} \tab The layout or "arrangement" of plot objects\cr
  --------------------------- \tab ------------------------------------------------------------------------------------------ \cr
}

\tabular{ll}{
  Unions of existing classes\tab \cr
  \code{\link{.spadesPlottables}} \tab The union of all object classes Plot can accept\cr
  \code{\link{.spadesPlotObjects}} \tab The union of spatialObjects and several others\cr
  \code{\link{spatialObjects}} \tab The union of several spatial classes\cr
  --------------------------- \tab ------------------------------------------------------------------------------------------ \cr
}
}
\author{
Eliot McIntire and Alex Chubaty
}
\seealso{
\code{\link{Plot}}, \code{\link{simInit}}
}

