% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R
\docType{methods}
\name{doEvent.checkpoint}
\alias{.checkpointSave}
\alias{checkpointLoad}
\alias{doEvent.checkpoint}
\title{Simulation checkpoints.}
\usage{
doEvent.checkpoint(sim, eventTime, eventType, debug = FALSE)

checkpointLoad(file)

.checkpointSave(sim, file)
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{eventTime}{A numeric specifying the time of the next event.}

\item{eventType}{A character string specifying the type of event: one of
either \code{"init"}, \code{"load"}, or \code{"save"}.}

\item{debug}{Optional logical flag determines whether sim debug info
will be printed (default \code{debug = FALSE}).}

\item{file}{The checkpoint file.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Save and reload the current state of the simulation,
including the state of the random number generator,
by scheduling checkpoint events.
}
\details{
\code{\link{checkpointLoad}} and \code{\link{.checkpointSave}} code based on:
\url{https://raw.githubusercontent.com/achubaty/r-tools/master/checkpoint.R}

RNG save code adapted from:
\url{http://www.cookbook-r.com/Numbers/Saving_the_state_of_the_random_number_generator/}
and \url{https://stackoverflow.com/questions/13997444/}
}
\author{
Alex Chubaty
}
\seealso{
\code{\link{.Random.seed}}.
}

