% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movement.R
\name{move}
\alias{move}
\alias{crw}
\title{Move}
\usage{
move(hypothesis = "crw", ...)

crw(
  agent,
  extent,
  stepLength,
  stddev,
  lonlat = FALSE,
  torus = FALSE,
  returnMatrix = FALSE
)
}
\arguments{
\item{hypothesis}{Character vector, length one, indicating which movement
hypothesis/method to test/use. Currently defaults to
'crw' (correlated random walk) using \code{crw}.}

\item{...}{arguments passed to the function in \code{hypothesis}}

\item{agent}{A \code{SpatVector} points geometry or a \verb{SpatialPoints*} (deprecated) object.
If is has attributes, e.g., \code{SpatialPointsDataFrame},
2 of the columns must
be \code{x1} and \code{y1}, indicating the previous location.
If it does not have these columns as attributes, \code{x1} and
\code{y1} will be assigned randomly.}

\item{extent}{An optional \code{Extent} object that will be used for \code{torus}.}

\item{stepLength}{Numeric vector of length 1 or number of agents describing
step length.}

\item{stddev}{Numeric vector of length 1 or number of agents describing
standard deviation of wrapped normal turn angles.}

\item{lonlat}{Logical. If \code{TRUE}, coordinates should be in degrees.
If \code{FALSE} coordinates represent planar ('Euclidean')
space (e.g. units of meters)}

\item{torus}{Logical. Should the movement be wrapped to the opposite
side of the map, as determined by the \code{extent} argument.
Default \code{FALSE}.}

\item{returnMatrix}{If \code{TRUE} then the return object will be a \code{matrix}. This will
be MUCH faster than retaining the \code{sp} or \code{SpatVector} class,
and thus will be much more effective for iterative \code{crw} calls}
}
\value{
A \code{SpatVector} points object with updated spatial position defined
by a single occurrence of step length(s) and turn angle(s).
}
\description{
Wrapper for selecting different animal movement methods.

This version uses just turn angles and step lengths to define the correlated random walk.
}
\details{
This simple version of a correlated random walk is largely the version that
was presented in Turchin 1998, but it was also used with bias modifications
in McIntire, Schultz, Crone 2007.
}
\examples{
origDTThreads <- data.table::setDTthreads(2L)
origNcpus <- options(Ncpus = 2L)

# using just matrix
N <- 10
xrange <- yrange <- c(-50, 50)
starts <- cbind(x = stats::runif(N, xrange[1], xrange[2]),
                y = stats::runif(N, yrange[1], yrange[2]))
moved <- crw(starts, stepLength = 5, stddev = 10)
plot(starts, col = rainbow(10), pch = 19)
points(moved, col = rainbow(10))

# as SpatVector
agent <- terra::vect(starts)
moved <- crw(agent, stepLength = 5, stddev = 10)
movedAgain <- crw(moved, stepLength = 5, stddev = 10)
terra::plot(agent)
terra::plot(moved, add = TRUE, col = "red")
terra::plot(movedAgain, add = TRUE, col = "green")

# 1000x faster!! -- returnMatrix = TRUE
agentOrig <- agent
reps <- 1e2
system.time({
  for (i in 1:reps) agent <- crw(agent, stepLength = 5, stddev = 10, returnMatrix = TRUE)
})
agent <- agentOrig
system.time({
  for (i in 1:reps) agent <- crw(agent, stepLength = 5, stddev = 10)
})

# as sp
if (requireNamespace("sp")) {
  agent <- sp::SpatialPoints(starts)
  spdf <- crw(agent, stepLength = 5, stddev = 10)
  spdfNew <- crw(spdf, stepLength = 5, stddev = 10)
  terra::plot(spdf, pch = 19)
  terra::points(spdfNew, col = "blue", pch = 19)
}

# clean up
data.table::setDTthreads(origDTThreads)
options(Ncpus = origNcpus)

}
\references{
Turchin, P. 1998. Quantitative analysis of movement: measuring and
modeling population redistribution in animals and plants.
Sinauer Associates, Sunderland, MA.

McIntire, E. J. B., C. B. Schultz, and E. E. Crone. 2007.
Designing a network for butterfly habitat restoration: where
individuals, populations and landscapes interact.
Journal of Applied Ecology 44:725-736.
}
\seealso{
\code{\link[terra:distance]{terra::distance()}}

\code{\link[=wrap]{wrap()}}
}
\author{
Eliot McIntire
}
