% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{saveSimList}
\alias{saveSimList}
\title{Save a whole \code{simList} object to disk}
\usage{
saveSimList(sim, filename, fileBackend = 0, filebackedDir = NULL, envir, ...)
}
\arguments{
\item{sim}{Either a \code{simList} or a character string of the name
of a \code{simList} that can be found in \code{envir}. Using
a character string will assign that object name to the saved
\code{simList}, so when it is recovered it will be given that
name.}

\item{filename}{Character string with the path for saving \code{simList}}

\item{fileBackend}{Numeric. \code{0} means don't do anything with
file backed rasters. Leave their file intact as is, in its place.
\code{1} means save a copy of the file backed rasters in \code{fileBackedDir}.
\code{2} means move all data in file-backed rasters to memory. This
means that the objects will be part of the main \code{RData} file
of the \code{simList}. Default is \code{0}.}

\item{filebackedDir}{Only used if \code{fileBackend} is 1.
\code{NULL}, the default, or Character string. If \code{NULL}, then then the
files will be copied to the directory:
\code{file.path(dirname(filename), "rasters")}. A character string
will be interpreted as a path to copy all rasters to.}

\item{envir}{If \code{sim} is a character string, then this must be provided.
It is the environment where the object named \code{sim} can
be found.}

\item{...}{Passed to \code{save}, e.g., \code{compression}}
}
\value{
A saved \code{.RData} file in \code{filename} location.
}
\description{
Because of the environment slot, this is not quite as straightforward as
just saving the object. This also has option for file-backed Rasters.
}
\seealso{
\code{\link{zipSimList}}
}
