% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-template.R
\name{openModules}
\alias{openModules}
\alias{openModules,character,character-method}
\alias{openModules,missing,missing-method}
\alias{openModules,missing,character-method}
\alias{openModules,character,missing-method}
\alias{openModules,simList,missing-method}
\title{Open all modules nested within a base directory}
\usage{
openModules(name, path)

\S4method{openModules}{character,character}(name, path)

\S4method{openModules}{missing,missing}()

\S4method{openModules}{missing,character}(path)

\S4method{openModules}{character,missing}(name)

\S4method{openModules}{simList,missing}(name)
}
\arguments{
\item{name}{Character vector with names of modules to open. If missing, then
all modules will be opened within the basedir.}

\item{path}{Character string of length 1. The base directory within which
there are only module subdirectories.}
}
\value{
Nothing is returned. All file are open via \code{file.edit}.
}
\description{
This is just a convenience wrapper for opening several modules at once, recursively.
A module is defined as any file that ends in \code{.R} or \code{.r} and has a
directory name identical to its filename. Thus, this must be case sensitive.
}
\note{
On Windows there is currently a bug in RStudio that prevents the editor
from opening when \code{file.edit} is called. \code{file.edit} does work if the
user types it at the command prompt. A message with the correct lines to copy
and paste is provided.
}
\examples{
\dontrun{openModules("~\SpaDESModules")}

}
\author{
Eliot McIntire
}
