% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{envir}
\alias{envir}
\alias{simList-accessors-envir}
\alias{envir,simList-method}
\alias{envir<-}
\alias{envir<-,simList-method}
\title{Simulation environment}
\usage{
envir(sim)

\S4method{envir}{simList}(sim)

envir(sim) <- value

\S4method{envir}{simList}(sim) <- value
}
\arguments{
\item{sim}{A \code{simList} object from which to extract element(s) or
in which to replace element(s).}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns or sets the value of the slot from the \code{simList} object.
}
\description{
Accessor functions for the \code{.envir} slot in a \code{simList} object.
These are included for advanced users.
}
\details{
Currently, only get and set methods are defined. Subset methods are not.
}
\seealso{
\code{\link{SpaDES.core-package}}, specifically the section 1.2.8 on simList environment.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{doEvent.checkpoint}}, \code{\link{events}},
  \code{\link{globals}}, \code{\link{inputs}},
  \code{\link{ls.simList}}, \code{\link{ls.str.simList}},
  \code{\link{modules}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}
\author{
Alex Chubaty
}
\concept{functions to access elements of a \code{simList} object}
