% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visiualization.R
\name{plot_Strength_Seurat}
\alias{plot_Strength_Seurat}
\title{Plot Localized Hotspot Strength Pattern on Seurat Object}
\usage{
plot_Strength_Seurat(
  Seurat_object,
  resultdf_list,
  RegionIDs_matrix,
  celltype_ligand,
  celltype_receptor,
  plot_size,
  L_R_pair_name = NULL
)
}
\arguments{
\item{Seurat_object}{A Seurat object}

\item{resultdf_list}{A result of data frame list from the output of \code{run_SpaCCI(..., analysis_scale = "local",...)} \code{`dataframelist`}}

\item{RegionIDs_matrix}{A result of matrix list from the output of \code{run_SpaCCI(..., analysis_scale = "local",...)} \code{`RegionIDs_matrix`}}

\item{celltype_ligand}{Ligand cell type string inputted by user, the name of the cell type should match the names in the \code{`spot_cell_proportion_dataframe`} during the \code{run_SpaCCI} analysis.}

\item{celltype_receptor}{Receptor cell type string inputted by user, the name of the cell type should match the names in the \code{`spot_cell_proportion_dataframe`} during the \code{run_SpaCCI} analysis.}

\item{plot_size}{As this function incorporate with \code{Seurat}'s \code{`SpatialFeaturePlot`}, this parameter could control the plotting size of the each spot.}

\item{L_R_pair_name}{Initially this is set to \code{NULL}, if one is interested in a specific Ligand-Receptor pair, then one could specify the L_R_pair_name here. Note: the input name should match the L-R pair name exists in the dataframe in the output of SpaCCI_local "dataframelist".}
}
\value{
The localized plot from the inferred cell-cell interaction on the local scale.
}
\description{
Visualize the inferred cell-cell interaction localized pattern on the tissue image with Seurat_object
}
\examples{
\donttest{
# Not Run

# Run localized hotspot plot
Result <- run_SpaCCI(..., analysis_scale = "local",...)
local_plot <- plot_Strength_Seurat(Seurat_object = gene_spot_df,
                                    resultdf_list = Result$dataframelist,
                                    RegionIDs_matrix = Result$RegionIDs_matrix,
                                    celltype_ligand = "Beta_cells",
                                    celltype_receptor = "T_ells",
                                    plot_size = 3)
}

}
