% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParentTaxa.R
\name{getParentTaxa}
\alias{getParentTaxa}
\title{Get the higher (parent) taxa associated with a taxon or taxon code}
\usage{
getParentTaxa(taxon = NULL, code = NULL, convert = TRUE)
}
\arguments{
\item{taxon}{A character vector of taxa (case-insensitive)}

\item{code}{A character vector of taxon codes (case sensitive)}

\item{convert}{Convert results from taxon codes to taxon names? Default: \code{TRUE}}
}
\value{
A named list, where names are taxon codes and values are character vectors representing parent taxa
}
\description{
Must specify either \code{taxon} or \code{code}. \code{taxon} is used if both are specified.
}
\examples{

getParentTaxa("ultic haploxeralfs")

getParentTaxa(code = c("ABCD", "DABC"))

getParentTaxa("folists", convert = FALSE)

}
\author{
Andrew G. Brown
}
