% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherTaxaLevels.R
\name{code_to_level}
\alias{code_to_level}
\title{Determine taxonomic level of a taxonomic letter code}
\usage{
code_to_level(code)
}
\arguments{
\item{code}{A character vector of taxon codes (case sensitive)}
}
\value{
A character vector containing \code{"order"}, \code{"suborder"}, \code{"greatgroup"} or \code{"subgroup"}
}
\description{
Determine taxonomic level of a taxonomic letter code
}
\examples{

# order level code (1 character)
code_to_level("B")

# subgroup level code (4 characters)
code_to_level("ABCD")

# subgroup level code (5 characters, 4 uppercase + 1 lowercase)
code_to_level("IFFZh")

}
