% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{global_fit_RGHD_ratio}
\alias{global_fit_RGHD_ratio}
\title{Global optimization of the 2m-RGHD function given empirical data, r bounds, and q/r bounds.}
\usage{
global_fit_RGHD_ratio(
  param_bounds,
  data,
  iter,
  weighted_rt = FALSE,
  n_cores = 1,
  clust
)
}
\arguments{
\item{param_bounds}{A list of sequences which indicate space where parameters should be generated and fit}

\item{data}{Vector of observed values}

\item{iter}{Integer indicating number of iterations to run grid search. Increasing iterations will increase decimal point precision of output parameters.}

\item{weighted_rt}{Boolean used to determine if the weighted right-tail cumulative distribution function should be used or not.}

\item{n_cores}{Integer used to indicate number of cores to be used for this function if a socket cluster object is not defined.}

\item{clust}{socket cluster object from 'parallel::makeCluster()'. This is used if you have already generated a socket cluster object and would like to run this functoin on it. If no object is defined, one will be made for this function call.}
}
\description{
This function generates a single set of optimized parameters and Psi Criterion for a given function within specified starting parameter bounds. This function uses Limited Memory BFGS as it's gradient descent algorithm.
}
