% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_summarize.R
\name{group_summarize}
\alias{group_summarize}
\alias{group_summarise}
\title{Calculate descriptive statistics for each group}
\usage{
group_summarize(x, group_cols, var_cols, output_format = "v1", ...)
}
\arguments{
\item{x}{A data.frame or tibble.}

\item{group_cols}{Vector of the names of the grouping columns.}

\item{var_cols}{Vector of the names of the variables of interest.}

\item{output_format}{The version of the output format (v0 or v1).}

\item{...}{Extra arguments passed to fxn, i.e. na.rm = FALSE, etc.}
}
\value{
A tibble

A group_summary object with slots for the results, grouping 
variables, variables of interest, and any other parameters passed in.
}
\description{
group_summarize performs descriptive statistics for each group 
in a data set.

The function takes as input a data.frame or tibble, the column names of 
grouping variables, and the column names of variables of interest.
}
\examples{
group_summarize(iris, "Species", c("Sepal.Length", "Sepal.Width"))
}
