% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist_spde.R
\name{.Q}
\alias{.Q}
\title{Helper function to generate precision matrix Q for simulation}
\usage{
.Q(
  mesh,
  barrier.triangles,
  range = 50,
  range_fraction = 0.2,
  sigma_u = 1,
  model = "spde"
)
}
\arguments{
\item{mesh}{The mesh created by R-INLA representing spatial area}

\item{barrier.triangles}{the list of triangles of the mesh in the barrier, only used for barrier model}

\item{range}{decorrelation range}

\item{range_fraction}{the fraction that sets the range over the "land"
parts of the barrier model. Only used with the barrier model}

\item{sigma_u}{the overall variance of the spatial process}

\item{model}{'spde' for the SPDE approach, 'barrier' for barrier approach}
}
\value{
Q a sparse precision matrix of type dgTMatrix
}
\description{
This creates the precision matrix from a mesh created by R-INLA with a
specified range. This is currently set up to support the standard spde
approach of precision matrices and the barrier model version. Similar
in purpose to .sp_covar.
}
\keyword{internal}
