% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_params-data.R
\docType{data}
\name{H_params}
\alias{H_params}
\title{Parameters for Examples of Constants Calculated by Headrick's Fifth-Order Polynomial Transformation}
\format{An object of class \code{"data.frame"}; Colnames are distribution names as inputs for
\code{\link[SimMultiCorrData]{calc_theory}}; rownames are param1, param2.}
\usage{
data(H_params)
}
\description{
These are the parameters for \code{\link[SimMultiCorrData]{Headrick.dist}}, which contains selected symmetrical and
asymmetrical theoretical densities with their associated values
of skewness (gamma1), standardized kurtosis (gamma2), and standardized fifth (gamma3) and
sixth (gamma4) cumulants.  Constants were calculated by Headrick using his fifth-order
polynomial transformation and given in his Table 1 (2002, p. 691-2, \doi{10.1016/S0167-9473(02)00072-5}).
Note that the standardized cumulants for the Gamma(10, 10)
distribution do not arise from using \eqn{\alpha = 10,\ \beta = 10}.  Therefore, either there is a typo in the table or
Headrick used a different parameterization.
}
\references{
Headrick TC (2002). Fast Fifth-order Polynomial Transforms for Generating Univariate and Multivariate
    Non-normal Distributions. Computational Statistics & Data Analysis, 40(4):685-711. \doi{10.1016/S0167-9473(02)00072-5}.
    (\href{http://www.sciencedirect.com/science/article/pii/S0167947302000725}{ScienceDirect})
}
\keyword{datasets}
