% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe_sp.R
\name{SISe_sp}
\alias{SISe_sp}
\title{Create a \code{SISe_sp} model}
\usage{
SISe_sp(u0, tspan, events = NULL, phi = NULL, upsilon = NULL,
  gamma = NULL, alpha = NULL, beta_t1 = NULL, beta_t2 = NULL,
  beta_t3 = NULL, beta_t4 = NULL, end_t1 = NULL, end_t2 = NULL,
  end_t3 = NULL, end_t4 = NULL, coupling = NULL, distance = NULL)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node,
see details.}

\item{tspan}{An increasing sequence of points in time where the
state of the system is to be returned.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{siminf_model}}.}

\item{phi}{A numeric vector with the initial environmental
infectious pressure in each node. Default NULL which gives 0
in each node.}

\item{upsilon}{Indirect transmission rate of the environmental
infectious pressure}

\item{gamma}{The recovery rate from infected to susceptible}

\item{alpha}{Shed rate from infected individuals}

\item{beta_t1}{The decay of the environmental infectious pressure
in interval 1.}

\item{beta_t2}{The decay of the environmental infectious pressure
in interval 2.}

\item{beta_t3}{The decay of the environmental infectious pressure
in interval 3.}

\item{beta_t4}{The decay of the environmental infectious pressure
in interval 4.}

\item{end_t1}{The non-inclusive day that ends interval 1.}

\item{end_t2}{The non-inclusive day that ends interval 2.}

\item{end_t3}{The non-inclusive day that ends interval 3.}

\item{end_t4}{The non-inclusive day that ends interval 4.}

\item{coupling}{The coupling between neighboring nodes}

\item{distance}{The distance matrix between neighboring nodes}
}
\value{
\code{SISe_sp}
}
\description{
Create a \code{SISe_sp} model to be used by the simulation
framework.
}
\details{
The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S}{The number of sucsceptible}
\item{I}{The number of infected}
}
}
\section{Beta}{

The time dependent beta is divided into four intervals of the year
\preformatted{
where 0 <= day < 365

Case 1: END_1 < END_2 < END_3 < END_4
INTERVAL_1 INTERVAL_2     INTERVAL_3     INTERVAL_4     INTERVAL_1
[0, END_1) [END_1, END_2) [END_2, END_3) [END_3, END_4) [END_4, 365)

Case 2: END_3 < END_4 < END_1 < END_2
INTERVAL_3 INTERVAL_4     INTERVAL_1     INTERVAL_2     INTERVAL_3
[0, END_3) [END_3, END_4) [END_4, END_1) [END_1, END_2) [END_2, 365)

Case 3: END_4 < END_1 < END_2 < END_3
INTERVAL_4 INTERVAL_1     INTERVAL_2     INTERVAL_3     INTERVAL_4
[0, END_4) [END_4, END_1) [END_1, END_2) [END_2, END_3) [END_3, 365)
}
}

