% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_grp.R
\name{predict_grp}
\alias{predict_grp}
\title{Prediction of equilibrium with regulation groups}
\usage{
predict_grp(E_ini_fun,beta_fun,A_fun,correl_fun, tol=0.00000001)
}
\arguments{
\item{E_ini_fun}{Numeric vector of initial concentrations}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{tol}{Tolerance for function \code{\link[stats]{uniroot}}}
}
\value{
List of seven elements:
\itemize{
\item \code{$pred_eiq}: numeric vector of intra-group relative concentrations \eqn{e_i^q} at equilibrium. Same length as \code{A_fun}.
\item \code{$pred_eq}: numeric vector of inter-group relative concentrations \eqn{e^q} at equilibrium. The length is the number of regulation groups.
\item \code{$pred_ei}: numeric vector of total relative concentrations \eqn{e_i} at equilibrium. Same length as \code{A_fun}.
\item \code{$pred_tau}: numeric vector of driving variable \eqn{tau^q} at equilibrium. The length is the number of regulation groups.
\item \code{$pred_Ei}: numeric vector of enzyme absolute concentrations \eqn{E_i} at equilibrium. Same length as \code{A_fun}.
\item \code{$pred_Eq}: numeric vector of sum of absolute concentrations in groups \eqn{E^q} at equilibrium. The length is the number of regulation groups.
\item \code{$pred_Etot}: numeric value of total concentration at equilibrium.
}
}
\description{
Gives the equilibrium for intra-group, inter-group and total relative concentrations at equilibrium
}
\details{
Gives values at effective equilibrium for intra-group \eqn{e_i^q}, inter-group \eqn{e^q} and total \eqn{e_i} relative concentrations, and group driving variable \eqn{\tau^q},
and also for absolute concentrations \eqn{E^i} and concentrations sum in groups \eqn{E^q}.
The equilibrium corresponds to null derivative for relative concentrations.

However, does not compute the theoretical intra-group equilibrium when there is competition, which is \eqn{e_i^q = 1/B_i}.
}
\section{Special results}{


When there are more than one positive or negative group and singletons with competition (\code{"CRPos"} or \code{"CRNeg"}), the equilibria are not predictable.
}

\examples{
#### For independancy "SC"
A <- c(1,10,30)
E0 <- c(30,30,30)
beta <- diag(1,3)

eq <- predict_grp(E0,beta,A,"SC")
#same results for pred_e and pred_ei
eq_th <- predict_th(A,"SC")

###### In presence of regulation, all enzyme co-regulated
A <- c(1,10,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
B <- apply(beta,1,sumbis) 

eq_grp <- predict_grp(E0,beta,A,"CRPos")
#same results for pred_e and pred_ei
eq_eff <- predict_eff(E0,B,A,"CRPos")


#Two groups: one negative group + one singleton
n <- 3
beta <- diag(1,n) 
beta[1,2] <- -0.32 
beta[2,1] <- 1/beta[1,2]

eq_grp <- predict_grp(E0,beta,A,"RegNeg")
eq_grp <- predict_grp(E0,beta,A,"CRNeg")


#Two groups: one positive group + one singleton 
n <- 3
beta <- diag(1,n) 
beta[1,2] <- 0.43 
beta[2,1] <- 1/beta[1,2]

eq_grp <- predict_grp(E0,beta,A,"RegPos")
eq_grp <- predict_grp(E0,beta,A,"CRPos")


\donttest{
#With saved simulation
data(data_sim_RegPos)
n <- data_sim_RegPos$param$n
num_s <- 1
pred_eq <- predict_grp(data_sim_RegPos$list_init$E0[num_s,1:n],
data_sim_RegPos$param$beta,data_sim_RegPos$list_init$A0[num_s,1:n],data_sim_RegPos$param$correl)

data(data_sim_RegNeg_1grpNeg1grpPos)
pred_eq <- predict_grp(data_sim_RegNeg_1grpNeg1grpPos$list_init$E0[num_s,],
data_sim_RegNeg_1grpNeg1grpPos$param$beta,c(1,10,30,50),"RegNeg")

}

}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.

Use function \code{\link{is.correl.authorized}} to see allowed constraints for \code{correl_fun}.

Use function \code{\link{predict_th}} (resp. \code{\link{predict_eff}}) to compute theoretical (resp. effective) equilibrium when there is no regulation groups (enzymes are all independent or all co-regulated).
}
