% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solv.2dg.polynom.R
\name{solv.2dg.polynom}
\alias{solv.2dg.polynom}
\title{Real solutions of quadratic equation}
\usage{
solv.2dg.polynom(a_fun,b_fun,c_fun)
}
\arguments{
\item{a_fun}{Numeric. The quadratic coefficient applied to \code{x^2}}

\item{b_fun}{Numeric. The linear coefficient applied to \code{x}}

\item{c_fun}{Numeric. The free term}
}
\value{
Three possible vectors:
\itemize{
   \item Numeric vector of length 2 if there is two real roots
   \item Numeric value if there is a double-root
   \item \code{NULL} if there is no real solution
}
}
\description{
Computes real solutions of quadratic equation
}
\details{
Quadratic equation is a second-degree polynomial equation of type \eqn{a x^2 + b x + c = 0}, 
where \code{a} is the quadratic coefficient, \code{b} the linear coefficient and \code{c} the free term.
}
\examples{
solv.2dg.polynom(3,2,1)
#result : NULL

solv.2dg.polynom(1,2,1)
#result : -1

solv.2dg.polynom(1,0,-1)
#result : c(1,-1)

}
