% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{CreateMotifMatrix}
\alias{CreateMotifMatrix}
\title{CreateMotifMatrix}
\usage{
CreateMotifMatrix(
  features,
  pwm,
  genome,
  score = FALSE,
  use.counts = FALSE,
  sep = c("-", "-"),
  ...
)
}
\arguments{
\item{features}{A GRanges object containing a set of genomic features}

\item{pwm}{A \code{\link[TFBSTools]{PFMatrixList}} or
\code{\link[TFBSTools]{PWMatrixList}}
object containing position weight/frequency matrices to use}

\item{genome}{Any object compatible with the \code{genome} argument
in \code{\link[motifmatchr]{matchMotifs}}}

\item{score}{Record the motif match score, rather than presence/absence
(default FALSE)}

\item{use.counts}{Record motif counts per region. If FALSE (default),
record presence/absence of motif. Only applicable if \code{score=FALSE}.}

\item{sep}{A length-2 character vector containing the separators to be used
when constructing matrix rownames from the GRanges}

\item{...}{Additional arguments passed to
\code{\link[motifmatchr]{matchMotifs}}}
}
\value{
Returns a sparse matrix
}
\description{
Create a motif x feature matrix from a set of genomic ranges,
the genome, and a set of position weight matrices.
}
\details{
Requires that motifmatchr is installed
\url{https://www.bioconductor.org/packages/motifmatchr/}.
}
\examples{
\dontrun{
library(JASPAR2018)
library(TFBSTools)
library(BSgenome.Hsapiens.UCSC.hg19)

pwm <- getMatrixSet(
  x = JASPAR2018,
  opts = list(species = 9606, all_versions = FALSE)
)
motif.matrix <- CreateMotifMatrix(
  features = StringToGRanges(rownames(atac_small), sep = c(":", "-")),
  pwm = pwm,
  genome = BSgenome.Hsapiens.UCSC.hg19,
  sep = c(":", "-")
)
}
}
