% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoosePopR.R
\name{MoosePopR}
\alias{MoosePopR}
\title{R function that gives the same functionality as the MoosePop program.}
\usage{
MoosePopR(
  survey.data,
  survey.block.area,
  stratum.data,
  density = NULL,
  abundance = NULL,
  numerator = NULL,
  denominator = NULL,
  block.id.var = "Block.ID",
  block.area.var = "Block.Area",
  stratum.var = "Stratum",
  stratum.blocks.var = "Stratum.Blocks",
  stratum.area.var = "Stratum.Area",
  conf.level = 0.9,
  survey.lonely.psu = "fail"
)
}
\arguments{
\item{survey.data}{A data frame containing counts of moose in each group along with a variable identifying 
the stratum (see stratum.var) and block (see block.id.var)}

\item{survey.block.area}{A data frame containing for each block, the block id (see block.id.var), the
area of the block (see block.area.var). The data frame can contain information for other blocks that
were not surveyed (e.g. for the entire population of blocks) and information from these
additional blocks will be ignored.}

\item{stratum.data}{A data frame containing for each stratum, the stratum id (see stratum.var), the total
number of blocks in the stratum (see stratum.blocks.var) and the total area of the stratum (see stratum.area.var)}

\item{density, abundance, numerator, denominator}{Right-handed formula identifying the variable(s) in the
survey.data data frame for which the density, abundance, or ratio (numerator/denominator) are to be estimated.}

\item{block.id.var}{Name of the variable in the data frames that identifies the block.id (the sampling unit)}

\item{block.area.var}{Name of the variable in data frames that contains the area of the blocks (area of sampling unit)}

\item{stratum.var}{Name of the variable in the data frames that identifies the classical stratum}

\item{stratum.blocks.var}{Name of the variable in the stratum.data data frame that contains the total number of
blocks in the stratum.}

\item{stratum.area.var}{Name of the variable in the stratum.data data.frame that contains the total stratum area.}

\item{conf.level}{Confidence level used to create confidence intervals.}

\item{survey.lonely.psu}{How to deal with lonely PSU within strata. See \code{surveyoptions} in the \code{survey} package.}
}
\value{
A data frame containing for each stratum and for all strata (identified as stratum id \code{.OVERALL}), the density,
   or abundance or ratio estimate along with its estimated standard error and large-sample normal-based confidence interval.
}
\description{
A stratified random sample of blocks in a survey area is conducted.
 In each block, groups of moose are observed (usually through an aerial survey).
 For each group of moose, the number of moose is recorded along with attributes
 such as sex or age.
 MoosePopR() assumes that sightability is 100\%.
 Use the SightabilityPopR() function to adjust for sightability < 100\%.
}
\examples{
 
##---- See the vignettes for examples on how to run this analysis.

}
\references{
To Be Added.
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{surveys}
\keyword{~MOOSEPOP}
\keyword{~moose}
