% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{$.Seurat}
\alias{$.Seurat}
\alias{$<-.Seurat}
\alias{[[<-,Seurat,character,missing,data.frame-method}
\alias{[[<-,Seurat,missing,missing,data.frame-method}
\alias{[[<-,Seurat,character,missing,factor-method}
\alias{[[<-,Seurat,character,missing,list-method}
\alias{[[<-,Seurat,missing,missing,list-method}
\alias{[[<-,Seurat,character,missing,vector-method}
\title{Cell-Level Meta Data}
\usage{
\method{$}{Seurat}(x, i)

\method{$}{Seurat}(x, i, ...) <- value

\S4method{[[}{Seurat,character,missing,data.frame}(x, i, j, ...) <- value

\S4method{[[}{Seurat,missing,missing,data.frame}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,factor}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,list}(x, i, j, ...) <- value

\S4method{[[}{Seurat,missing,missing,list}(x, i, j, ...) <- value

\S4method{[[}{Seurat,character,missing,vector}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{i}{Name of cell-level meta data}

\item{...}{Ignored}

\item{value}{A vector to add as cell-level meta data}

\item{j}{Ignored}
}
\value{
{$}: Metadata column \code{i} for object \code{x};
\strong{note}: unlike \code{[[}, \code{$} drops the shape of the metadata
to return a vector instead of a data frame

\code{$<-}: \code{x} with metadata \code{value} saved as \code{i}
}
\description{
Get and set cell-level meta data
}
\examples{
# Get metadata using `$'
head(pbmc_small$groups)

# Add metadata using the `$' operator
set.seed(42)
pbmc_small$value <- sample(1:3, size = ncol(pbmc_small), replace = TRUE)
head(pbmc_small[["value"]])

}
\seealso{
Seurat object, validity, and interaction methods
\code{\link{Seurat-class}},
\code{\link{Seurat-validity}},
\code{\link{[[.Seurat}()},
\code{\link{[[<-,Seurat,NULL}},
\code{\link{[[<-,Seurat}},
\code{\link{dim.Seurat}()},
\code{\link{dimnames.Seurat}()},
\code{\link{merge.Seurat}()},
\code{\link{names.Seurat}()},
\code{\link{subset.Seurat}()}
}
\concept{seurat}
