% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleImagePlot}
\alias{SingleImagePlot}
\title{Single Spatial Plot}
\usage{
SingleImagePlot(
  data,
  col.by = NA,
  col.factor = TRUE,
  cols = NULL,
  shuffle.cols = FALSE,
  size = 0.1,
  molecules = NULL,
  mols.size = 0.1,
  mols.cols = NULL,
  mols.alpha = 1,
  alpha = molecules \%iff\% 0.3 \%||\% 0.6,
  border.color = "white",
  border.size = NULL,
  na.value = "grey50",
  dark.background = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame with at least the following columns:
\itemize{
 \item \dQuote{\code{x}}: Spatial-resolved \emph{x} coordinates, will be
  plotted on the \emph{y}-axis
 \item \dQuote{\code{y}}: Spatially-resolved \emph{y} coordinates, will be
  plotted on the \emph{x}-axis
 \item \dQuote{\code{cell}}: Cell name
 \item \dQuote{\code{boundary}}: Segmentation boundary label; when plotting
  multiple segmentation layers, the order of boundary transparency is set by
  factor levels for this column
}
Can pass \code{NA} to \code{data} suppress segmentation visualization}

\item{col.by}{Name of column in \code{data} to color cell segmentations by;
pass \code{NA} to suppress coloring}

\item{col.factor}{Are the colors a factor or discrete?}

\item{cols}{Colors for cell segmentations; can be one of the
following:
\itemize{
 \item \code{NULL} for default ggplot2 colors
 \item A numeric value or name of a
  \link[RColorBrewer:RColorBrewer]{color brewer palette}
 \item Name of a palette for \code{\link{DiscretePalette}}
 \item A vector of colors equal to the length of unique levels of
  \code{data$col.by}
}}

\item{shuffle.cols}{Randomly shuffle colors when a palette or
vector of colors is provided to \code{cols}}

\item{size}{Point size for cells when plotting centroids}

\item{molecules}{A data frame with spatially-resolved molecule coordinates;
should have the following columns:
\itemize{
 \item \dQuote{\code{x}}: Spatial-resolved \emph{x} coordinates, will be
  plotted on the \emph{y}-axis
 \item \dQuote{\code{y}}: Spatially-resolved \emph{y} coordinates, will be
  plotted on the \emph{x}-axis
 \item \dQuote{\code{molecule}}: Molecule name
}}

\item{mols.size}{Point size for molecules}

\item{mols.cols}{A vector of color for molecules. The "Set1" palette from
RColorBrewer is used by default.}

\item{mols.alpha}{Alpha value for molecules, should be between 0 and 1}

\item{alpha}{Alpha value, should be between 0 and 1; when plotting multiple
boundaries, \code{alpha} is equivalent to max alpha}

\item{border.color}{Color of cell segmentation border; pass \code{NA}
to suppress borders for segmentation-based plots}

\item{border.size}{Thickness of cell segmentation borders; pass \code{NA}
to suppress borders for centroid-based plots}

\item{na.value}{Color value for \code{NA} segmentations when
using custom scale}

\item{...}{Ignored}
}
\value{
A ggplot object
}
\description{
Single Spatial Plot
}
\keyword{internal}
