% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R, R/convenience.R
\name{SpatialPlot}
\alias{SpatialPlot}
\alias{SpatialDimPlot}
\alias{SpatialFeaturePlot}
\title{Visualize spatial clustering and expression data.}
\usage{
SpatialPlot(
  object,
  group.by = NULL,
  features = NULL,
  images = NULL,
  cols = NULL,
  image.alpha = 1,
  crop = TRUE,
  slot = "data",
  keep.scale = "feature",
  min.cutoff = NA,
  max.cutoff = NA,
  cells.highlight = NULL,
  cols.highlight = c("#DE2D26", "grey50"),
  facet.highlight = FALSE,
  label = FALSE,
  label.size = 5,
  label.color = "white",
  label.box = TRUE,
  repel = FALSE,
  ncol = NULL,
  combine = TRUE,
  pt.size.factor = 1.6,
  alpha = c(1, 1),
  stroke = 0.25,
  interactive = FALSE,
  do.identify = FALSE,
  identify.ident = NULL,
  do.hover = FALSE,
  information = NULL
)

SpatialDimPlot(
  object,
  group.by = NULL,
  images = NULL,
  cols = NULL,
  crop = TRUE,
  cells.highlight = NULL,
  cols.highlight = c("#DE2D26", "grey50"),
  facet.highlight = FALSE,
  label = FALSE,
  label.size = 7,
  label.color = "white",
  repel = FALSE,
  ncol = NULL,
  combine = TRUE,
  pt.size.factor = 1.6,
  alpha = c(1, 1),
  image.alpha = 1,
  stroke = 0.25,
  label.box = TRUE,
  interactive = FALSE,
  information = NULL
)

SpatialFeaturePlot(
  object,
  features,
  images = NULL,
  crop = TRUE,
  slot = "data",
  keep.scale = "feature",
  min.cutoff = NA,
  max.cutoff = NA,
  ncol = NULL,
  combine = TRUE,
  pt.size.factor = 1.6,
  alpha = c(1, 1),
  image.alpha = 1,
  stroke = 0.25,
  interactive = FALSE,
  information = NULL
)
}
\arguments{
\item{object}{A Seurat object}

\item{group.by}{Name of meta.data column to group the data by}

\item{features}{Name of the feature to visualize. Provide either group.by OR
features, not both.}

\item{images}{Name of the images to use in the plot(s)}

\item{cols}{Vector of colors, each color corresponds to an identity class.
This may also be a single character or numeric value corresponding to a
palette as specified by \code{\link[RColorBrewer]{brewer.pal.info}}. By
default, ggplot2 assigns colors}

\item{image.alpha}{Adjust the opacity of the background images. Set to 0 to
remove.}

\item{crop}{Crop the plot in to focus on points plotted. Set to \code{FALSE} to show
entire background image.}

\item{slot}{If plotting a feature, which data slot to pull from (counts,
data, or scale.data)}

\item{keep.scale}{How to handle the color scale across multiple plots. Options are:
\itemize{
  \item{"feature" (default; by row/feature scaling):}{ The plots for each individual feature are scaled to the maximum expression of the feature across the conditions provided to 'split.by'.}
  \item{"all" (universal scaling):}{ The plots for all features and conditions are scaled to the maximum expression value for the feature with the highest overall expression.}
  \item{NULL (no scaling):}{ Each individual plot is scaled to the maximum expression value of the feature in the condition provided to 'split.by'. Be aware setting NULL will result in color scales that are not comparable between plots.}
}}

\item{min.cutoff, max.cutoff}{Vector of minimum and maximum cutoff
values for each feature, may specify quantile in the form of 'q##' where '##'
is the quantile (eg, 'q1', 'q10')}

\item{cells.highlight}{A list of character or numeric vectors of cells to
highlight. If only one group of cells desired, can simply pass a vector
instead of a list. If set, colors selected cells to the color(s) in
cols.highlight}

\item{cols.highlight}{A vector of colors to highlight the cells as; ordered
the same as the groups in cells.highlight; last color corresponds to
unselected cells.}

\item{facet.highlight}{When highlighting certain groups of cells, split each
group into its own plot}

\item{label}{Whether to label the clusters}

\item{label.size}{Sets the size of the labels}

\item{label.color}{Sets the color of the label text}

\item{label.box}{Whether to put a box around the label text (geom_text vs
geom_label)}

\item{repel}{Repels the labels to prevent overlap}

\item{ncol}{Number of columns if plotting multiple plots}

\item{combine}{Combine plots into a single gg object; note that if TRUE;
themeing will not work when plotting multiple features/groupings}

\item{pt.size.factor}{Scale the size of the spots.}

\item{alpha}{Controls opacity of spots. Provide as a vector specifying the
min and max for SpatialFeaturePlot. For SpatialDimPlot, provide a single
alpha value for each plot.}

\item{stroke}{Control the width of the border around the spots}

\item{interactive}{Launch an interactive SpatialDimPlot or SpatialFeaturePlot
session, see \code{\link{ISpatialDimPlot}} or
\code{\link{ISpatialFeaturePlot}} for more details}

\item{do.identify, do.hover}{DEPRECATED in favor of \code{interactive}}

\item{identify.ident}{DEPRECATED}

\item{information}{An optional dataframe or matrix of extra information to be displayed on hover}
}
\value{
If \code{do.identify}, either a vector of cells selected or the object
with selected cells set to the value of \code{identify.ident} (if set). Else,
if \code{do.hover}, a plotly object with interactive graphics. Else, a ggplot
object
}
\description{
SpatialPlot plots a feature or discrete grouping (e.g. cluster assignments) as
spots over the image that was collected. We also provide SpatialFeaturePlot
and SpatialDimPlot as wrapper functions around SpatialPlot for a consistent
naming framework.
}
\examples{
\dontrun{
# For functionality analagous to FeaturePlot
SpatialPlot(seurat.object, features = "MS4A1")
SpatialFeaturePlot(seurat.object, features = "MS4A1")

# For functionality analagous to DimPlot
SpatialPlot(seurat.object, group.by = "clusters")
SpatialDimPlot(seurat.object, group.by = "clusters")
}

}
\concept{convenience}
\concept{spatial}
\concept{visualization}
