% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{as.loom}
\alias{as.loom}
\alias{as.loom.Seurat}
\title{Convert objects to loom objects}
\usage{
as.loom(x, ...)

\method{as.loom}{Seurat}(
  x,
  assay = NULL,
  filename = file.path(getwd(), paste0(Project(object = x), ".loom")),
  max.size = "400mb",
  chunk.dims = NULL,
  chunk.size = NULL,
  overwrite = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{loom}}

\item{...}{Ignored for now}

\item{assay}{Assay to store in loom file}

\item{filename}{The name of the new loom file}

\item{max.size}{Set maximum chunk size in terms of memory usage, unused if \code{chunk.dims} is set;
may pass a character string (eg. \code{3gb}, \code{1200mb}) or exact value in bytes}

\item{chunk.dims}{Matrix chunk dimensions; auto-determined by default}

\item{chunk.size}{Maximum number of cells read/written to disk at once; auto-determined by default}

\item{overwrite}{Overwrite an already existing loom file?}

\item{verbose}{Display a progress bar}
}
\description{
Convert objects to loom objects
}
\details{
The Seurat method for \code{as.loom} will try to automatically fill in datasets based on data presence.
For example, if an assay's scaled data slot isn't filled, then dimensional reduction and graph information
will not be filled, since those depend on scaled data. The following is a list of how datasets will be filled
\itemize{
  \item \code{counts} will be stored in \code{matrix}
  \item Cell names will be stored in \code{col_attrs/CellID}; feature names will be stored in \code{row_attrs/Gene}
  \item \code{data} will be stored in \code{layers/norm_data}
  \item \code{scale.data} will be stored in \code{layers/scale_data}
  \item Cell-level metadata will be stored in \code{col_attrs}; all periods '.' in metadata will be replaced with underscores '_'
  \item Clustering information from \code{Idents(object = x)} will be stored in \code{col_attrs/ClusterID} and \code{col_attrs/ClusterName}
  for the numeric and string representation of the factor, respectively
  \item Feature-level metadata will be stored in \code{Feature_attrs}; all periods '.' in metadata will be replaced with underscores '_'
  \item Variable features, if set, will be stored in \code{row_attrs/Selected}; features declared as variable will be stored as '1',
  others will be stored as '0'
  \item Dimensional reduction information for the assay provided will be stored in \code{col_attrs} for cell embeddings and \code{row_attrs}
   for feature loadings; datasets will be named as \code{name_type} where \code{name} is the name within the Seurat object
   and \code{type} is \code{cell_embeddings} or \code{feature_loadings}; if feature loadings have been projected for all features,
   then projected loadings will be stored instead and \code{type} will be \code{feature_loadings_projected}
  \item Nearest-neighbor graphs that start with the name of the assay will be stored in \code{col_graphs}
  \item Assay information will be stored as an HDF5 attribute called \code{assay} at the root level
}
}
\examples{
\dontrun{
lfile <- as.loom(x = pbmc_small)
}

}
\seealso{
\code{\link[loomR]{create}}
}
