% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{as.Seurat}
\alias{as.Seurat}
\alias{as.Seurat.CellDataSet}
\alias{as.Seurat.loom}
\alias{as.Seurat.SingleCellExperiment}
\title{Convert objects to Seurat objects}
\usage{
as.Seurat(x, ...)

\method{as.Seurat}{CellDataSet}(x, slot = "counts", assay = "RNA", verbose = TRUE, ...)

\method{as.Seurat}{loom}(
  x,
  cells = "CellID",
  features = "Gene",
  normalized = NULL,
  scaled = NULL,
  assay = NULL,
  verbose = TRUE,
  ...
)

\method{as.Seurat}{SingleCellExperiment}(
  x,
  counts = "counts",
  data = "logcounts",
  assay = "RNA",
  project = "SingleCellExperiment",
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{Seurat}}

\item{...}{Arguments passed to other methods}

\item{slot}{Slot to store expression data as}

\item{assay}{Name to store expression matrices as}

\item{verbose}{Display progress updates}

\item{cells}{The name of the dataset within \code{col_attrs} containing cell names}

\item{features}{The name of the dataset within \code{row_attrs} containing feature names}

\item{normalized}{The name of the dataset within \code{layers} containing the
normalized expression matrix; pass \code{/matrix} (with preceeding forward slash) to store
\code{/matrix} as normalized data}

\item{scaled}{The name of the dataset within \code{layers} containing the scaled expression matrix}

\item{counts}{name of the SingleCellExperiment assay to store as \code{counts};
set to \code{NULL} if only normalized data are present}

\item{data}{name of the SingleCellExperiment assay to slot as \code{data}.
Set to NULL if only counts are present}

\item{project}{Project name for new Seurat object}
}
\description{
Convert objects to Seurat objects
}
\details{
The \code{loom} method for \code{as.Seurat} will try to automatically fill in a Seurat object based on data presence.
For example, if no normalized data is present, then scaled data, dimensional reduction informan, and neighbor graphs
will not be pulled as these depend on normalized data. The following is a list of how the Seurat object will be constructed
\itemize{
  \item If no assay information is provided, will default to an assay name in a root-level HDF5 attribute called \code{assay};
  if no attribute is present, will default to "RNA"
  \item Cell-level metadata will consist of all one-dimensional datasets in \code{col_attrs} \strong{except} datasets named "ClusterID", "ClusterName",
  and whatever is passed to \code{cells}
  \item Identity classes will be set if either \code{col_attrs/ClusterID} or \code{col_attrs/ClusterName} are present; if both are present, then
  the values in \code{col_attrs/ClusterID} will set the order (numeric value of a factor) for values in \code{col_attrs/ClusterName}
  (charater value of a factor)
  \item Feature-level metadata will consist of all one-dimensional datasets in \code{row_attrs} \strong{except} datasets named "Selected" and whatever
  is passed to \code{features}; any feature-level metadata named "variance_standardized", "variance_expected", or "dispersion_scaled" will have
  underscores "_" replaced with a period "."
  \item Variable features will be set if \code{row_attrs/Selected} exists and it is a numeric type
  \item If a dataset is passed to \code{normalized}, stored as a sparse matrix in \code{data};
  if no dataset provided, \code{scaled} will be set to \code{NULL}
  \item If a dataset is passed to \code{scaled}, stored as a dense matrix in \code{scale.data}; all rows entirely consisting of \code{NA}s
  will be removed
  \item If a dataset is passed to \code{scaled}, dimensional reduction information will assembled from cell embedding information
  stored in \code{col_attrs}; cell embeddings will be pulled from two-dimensional datasets ending with "_cell_embeddings"; priority will
  be given to cell embeddings that have the name of \code{assay} in their name; feature loadings will be added from two-dimensional
  datasets in \code{row_attrs} that start with the name of the dimensional reduction and end with either "feature_loadings" or
  "feature_loadings_projected" (priority given to the latter)
  \item If a dataset is passed to \code{scaled}, neighbor graphs will be pulled from \code{col_graphs}, provided the name starts
  with the value of \code{assay}
}
}
\examples{
\dontrun{
lfile <- as.loom(x = pbmc_small)
pbmc <- as.Seurat(x = lfile)
}

}
