% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\docType{class}
\name{SpatialImage-class}
\alias{SpatialImage-class}
\alias{SpatialImage}
\alias{Cells.SpatialImage}
\alias{GetImage.SpatialImage}
\alias{GetTissueCoordinates.SpatialImage}
\alias{Radius.SpatialImage}
\alias{RenameCells.SpatialImage}
\alias{[.SpatialImage}
\alias{dim.SpatialImage}
\alias{subset.SpatialImage}
\title{The SpatialImage class}
\usage{
\method{Cells}{SpatialImage}(x)

\method{GetImage}{SpatialImage}(object, mode = c("grob", "raster", "plotly", "raw"), ...)

\method{GetTissueCoordinates}{SpatialImage}(object, ...)

\method{Radius}{SpatialImage}(object)

\method{RenameCells}{SpatialImage}(object, new.names = NULL, ...)

\method{[}{SpatialImage}(x, i, ...)

\method{dim}{SpatialImage}(x)

\method{subset}{SpatialImage}(x, cells, ...)
}
\arguments{
\item{x, object}{An object inheriting from \code{SpatialImage}}

\item{mode}{How to return the image; should accept one of 'grob', 'raster',
'plotly', or 'raw'}

\item{...}{Arguments passed to other methods}

\item{new.names}{vector of new cell names}

\item{i, cells}{A vector of cells to keep}
}
\description{
The SpatialImage class is a virtual class representing spatial information for
Seurat. All spatial image information must inherit from this class for use with
\code{Seurat} objects
}
\section{Slots}{

\describe{
\item{\code{assay}}{Name of assay to associate image data with; will give this image
priority for visualization when the assay is set as the active/default assay
in a \code{Seurat} object}

\item{\code{key}}{Key for the image}
}}

\section{Provided methods}{

These methods are defined on the \code{SpatialImage} object and should not be
overwritten without careful thought
\itemize{
  \item \code{\link{DefaultAssay}} and \code{\link{DefaultAssay<-}}
  \item \code{\link{Key}} and \code{\link{Key<-}}
  \item \code{\link{IsGlobal}}
  \item \code{\link{Radius}}; this method \emph{can} be overridden to provide
  a spot radius for image objects
}
}

\section{Required methods}{

All subclasses of the \code{SpatialImage} class must define the following methods;
simply relying on the \code{SpatialImage} method will result in errors. For required
parameters and their values, see the \code{Usage} and \code{Arguments} sections
\describe{
  \item{\code{\link{Cells}}}{Return the cell/spot barcodes associated with each position}
  \item{\code{\link{dim}}}{Return the dimensions of the image for plotting in \code{(Y, X)} format}
  \item{\code{\link{GetImage}}}{Return image data; by default, must return a grob object}
  \item{\code{\link{GetTissueCoordinates}}}{Return tissue coordinates; by default,
  must return a two-column data.frame with x-coordinates in the first column and y-coordiantes
  in the second}
  \item{\code{\link{Radius}}}{Return the spot radius; returns \code{NULL} by
  default for use with non-spot image technologies}
  \item{\code{\link{RenameCells}}}{Rename the cell/spot barcodes for this image}
  \item{\code{\link{subset}} and \code{[}}{Subset the image data by cells/spots;
  \code{[} should only take \code{i} for subsetting by cells/spots}
}
These methods are used throughout Seurat, so defining them and setting the proper
defaults will allow subclasses of \code{SpatialImage} to work seamlessly
}

